
#include <dirent.h>
#include <sys/stat.h>
#include <signal.h>
#include <unistd.h>

#include <kapp.h>
#include <kwm.h>
#include <kio_job.h>

#include "kmainwidget.h"
#include "droptarget.h"
#include "kmytablistbox.h"
#include "kfileio.h"
#include "main.h"

// Do the tmp stuff correctly - thanks to Harri Porten for
// reminding me (sven)
#ifdef HAVE_PATHS_H
#include <paths.h>
#endif

#ifndef _PATH_TMP
#define _PATH_TMP "/tmp/"
#endif

CaitooApp* app = NULL;

static void cleanup(void);
static void setSignalHandler(void (*handler)(int));

static msg_handler oldMsgHandler = NULL;

//--- Sven's pseudo IPC&locking start ---
static void writePid()
{
  FILE* lck;
  char nlck[80];
  sprintf (nlck, "%s.caitoo%d.lck", _PATH_TMP, getuid());
  lck = fopen (nlck, "w");
  fprintf (lck, "%d", getpid());
  fclose (lck);
}

static void checkMessage()
{
  char lf[80];
  sprintf (lf, "%s.caitoo%d.msg", _PATH_TMP, getuid());
  if (access(lf, F_OK) != 0)
  {
    debug ("No message for me");
    return;
  }
  QString cmd;
  QString delcmd;
  cmd = kFileToString(lf);
  delcmd.sprintf("rm -rf %s.caitoo%d.msg", _PATH_TMP, getuid());
  system (delcmd.data()); // unlink
  // find a KMMainWin
  KMainWidget *kmmWin = 0;
  if (kapp->topWidget() && kapp->topWidget()->isA("KMainWidget"))
    kmmWin = (KMainWidget *) kapp->topWidget();

  if (cmd.find ("show") == 0)
  {
    //printf ("show();\n");
    if (!kmmWin)
    {
      kmmWin = new KMainWidget;
      kmmWin->show(); // thanks, Patrick!
    }
    else
      KWM::activate(kmmWin->winId());
    //kmmWin->show();
    //kmmWin->raise();
  }
  else {
    int j;
    int i = cmd.find ("add ", 0, true);
    if (i==-1)
      return; // not an add command

    QString url = "";

    j = cmd.find('\n', i);
    url = cmd.mid(i+4,j-i-4);

    //printf ("check();\n");
    if (!kmmWin)
      kmmWin = new KMainWidget;
    KWM::activate(kmmWin->winId());
    //kmmWin->show();
    //kmmWin->raise();
    kmmWin->addTransfer( url );
  }
}
//--- Sven's pseudo IPC&locking end ---


//-----------------------------------------------------------------------------
// Crash recovery signal handler
static void signalHandler(int sigId)
{
  //--- Sven's pseudo IPC&locking start ---
  if (sigId == SIGUSR1) {
    fprintf(stderr, "*** Caitoo got message\n");
    checkMessage();
    setSignalHandler(signalHandler);
    return;
  }
  //--- Sven's pseudo IPC&locking end ---

  fprintf(stderr, "*** Caitoo got signal %d\n", sigId);

  if ( sigId != SIGSEGV && kmain ) {
    fprintf(stderr, "*** Caitoo saving data\n");
    delete kmain;
  }

  // If Caitoo crashes again below this line we consider the data lost :-|
  // Otherwise Caitoo will end in an infinite loop.
  setSignalHandler(SIG_DFL);
  cleanup();
  exit(1);
}


//-----------------------------------------------------------------------------
static void setSignalHandler(void (*handler)(int))
{
  signal(SIGSEGV, handler);
  signal(SIGKILL, handler);
  signal(SIGTERM, handler);
  signal(SIGHUP,  handler);
  signal(SIGFPE,  handler);
  signal(SIGABRT, handler);

  // catch also the keyboard interrupt
  signal(SIGINT, handler);

  //--- Sven's pseudo IPC&locking start ---
  signal(SIGUSR1,  handler);
  //--- Sven's pseudo IPC&locking end ---
}


static void cleanup(void)
{
  qInstallMsgHandler(oldMsgHandler);
  QString cmd;
  //--- Sven's pseudo IPC&locking start ---
  cmd.sprintf("rm -rf %s.caitoo%d.lck", _PATH_TMP, getuid());
  system (cmd.data()); // delete your owns only
  cmd.sprintf("rm -rf %s.caitoo%d.msg", _PATH_TMP, getuid());
  system (cmd.data()); // delete your owns only
  //--- Sven's pseudo IPC&locking end ---
}


void testDir( const char *_name ) {
  DIR *dp;
  QString c = getenv("HOME");
  c += _name;
  dp = opendir(c.data());
  if (dp == NULL)
    ::mkdir(c.data(), S_IRWXU);
  else
    closedir(dp);
}


CaitooApp::CaitooApp( int &argc, char **argv) :KApplication(argc, argv, "caitoo")
{
  dndfilter = new MotifDNDHandler();
}


bool CaitooApp::x11EventFilter( XEvent * xevent ){

  if ( KApplication::x11EventFilter(xevent) )
    return true;

  return dndfilter->handleEvent( xevent );
}


int main( int argc, char **argv ) {

  //--- Sven's pseudo IPC&locking start ---
  app = 0;
  {
    int pId;
    
    char lf[80];
    sprintf (lf, "%s.caitoo%d.lck", _PATH_TMP, getuid());
    if (access (lf, F_OK) != 0) {
      writePid(); // we are server and ready
    } else {
      FILE *lock, *msg;
      lock = fopen (lf, "r");
      fscanf (lock, "%d", &pId);
      fclose (lock);
      sprintf (lf, "%s.caitoo%d.msg", _PATH_TMP, getuid());
      msg = fopen (lf, "w");
      app = new CaitooApp(argc, argv); // clear arg list
      argc--;
      argv++;

      // process arguments
      if ( argc > 0 ) {
	fprintf (msg, "add %s\n", argv[0]);
      } else {
	fprintf (msg, "show");
      }

      fclose (msg);                   //message written

      if (pId < 0) {                   // server busy?
        if (kill(0-pId, 0) != 0) {     // try if it lives at all
          debug ("Server died while busy");
          writePid();             // he died and left his pid uncleaned
        } else {
          debug ("Server is busy - message pending");
          exit (0);                   // ok he lives but is busy
        }
      } else {                           // if not busy
        if (kill (pId, SIGUSR1) != 0) { // Dead?
          debug ("Server died while ready");
          writePid();             // then we are server
        } else {
          debug ("Server is ready - message sent");
          exit (0);
        }
      }
    }
    debug ("We are starting normaly");
    sprintf(lf, "rm -rf %s.caitoo%d.msg", _PATH_TMP, getuid());
    system (lf); // clear old mesage
  }
  //--- Sven's pseudo IPC&locking end ---

  testDir("/.kde");
  testDir("/.kde/share");
  testDir("/.kde/share/apps");
  testDir("/.kde/share/apps/caitoo");
  testDir("/.kde/share/apps/caitoo/logs");
  
  if ( app == 0L ) {
    app = new CaitooApp(argc, argv);
  }

  setSignalHandler(signalHandler);

  KIOJob::initStatic();
  KMyTabListBox::initStatic();

  // create a new caitoo widget
  
  KMainWidget mainw;
      
  if ( ! app->isRestored() ) {
    KWM::moveToDesktop( kmain->winId(), KWM::currentDesktop() );
    KWM::moveToDesktop( drop_target->winId(), KWM::currentDesktop() );
  }

  app->setMainWidget( kmain );

  // process arguments

  if ( argc > 1 ) {
    QString url = argv[1];
    kmain->addTransfer( url );
  }

  app->exec();
  cleanup();
}
