/************************************************************
  	Copyright (c) 99  Olof Wogast

  	This code is under GPL - see COPYING.
  ************************************************************/

//#ifndef ASKFORDIRECTORYDLG_CPP
//#define ASKFORDIRECTORYDLG_CPP

#include "askfordirectorydlg.h"
#include "askfordirectorydlg.moc"


AskForDirectoryDlg::AskForDirectoryDlg( QString *stringToReturn, const char *labelText, QWidget *parent, const char *name = 0 )
  : QDialog( parent, name, TRUE ) //Make the dialog modal.
{
  AskForDirectoryDlg::stringToReturn = stringToReturn;

  infoLabel = new QLabel( labelText, this );
  infoLabel->setGeometry( 10, 10, infoLabel->sizeHint().width(), infoLabel->sizeHint().height() );
  
  stringEdit = new QLineEdit( this );
  stringEdit->setGeometry( infoLabel->x(), infoLabel->y() + infoLabel->height() + 5, infoLabel->width(), stringEdit->sizeHint().height() );
	
  okPushButton = new QPushButton( "&Ok", this );
  okPushButton->setDefault( TRUE );
  okPushButton->setEnabled( FALSE );
  
  quitPushButton = new QPushButton("&Quit", this );
  quitPushButton->setGeometry( width() - 10 - quitPushButton->sizeHint().width(), stringEdit->y() + stringEdit->height() + 5, quitPushButton->sizeHint().width(), quitPushButton->sizeHint().height() );

  okPushButton->setGeometry( quitPushButton->x() - 5 - okPushButton->sizeHint().width() , quitPushButton->y(), okPushButton->sizeHint().width(), okPushButton->sizeHint().height() );

  connect( okPushButton, SIGNAL( clicked() ), SLOT( okPushButtonClicked() ) );
  connect( quitPushButton, SIGNAL( clicked() ), SLOT( quitPushButtonClicked() ) );
  connect( stringEdit, SIGNAL( textChanged( const char * ) ), SLOT( directoryChanged( const char * ) ) );
}

void AskForDirectoryDlg::okPushButtonClicked( void )
{
  *stringToReturn = stringEdit->text();
  accept();
}

void AskForDirectoryDlg::quitPushButtonClicked( void )
{
  //  qApp->quit(); Doesn't work here for some reason unknown to me. If you know, please mail olof.wolgast@caran.se and tell why.
  exit( 0 );
}

void AskForDirectoryDlg::directoryChanged( const char *newText )
{
  if ( strlen( newText ) == 0 )
    {
      okPushButton->setEnabled( FALSE );
    }
  else
    {
      okPushButton->setEnabled( TRUE );
    }
}

//#endif



