/************************************************************
        Copyright (c) 1997 Michael Glauche
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/


#include "ksoaedit.h"
#include "ksoaedit.moc"
#include "patternDialog.h"
#include <stdlib.h>
#include <qlabel.h>
#include "ktablistbox.h"
#include <qpushbt.h>
#include <qlined.h>
#include <qcombo.h>
#include <qlayout.h>
#include <qdatetm.h>
#include <qregexp.h>
#include <qmsgbox.h>

const char *TYPES[] = {"","A","NS","","","CNAME","SOA","MB","MG","MR","","WKS",
                        "PTR","HINFO","MINFO","MX","TXT","RP","AFSDB","X25",
                        "ISDN","RT"} ;          


ksoaedit::ksoaedit( PrimaryDomain *pl, QWidget* parent,
		   const char* name )
                   : QDialog ( parent, name, TRUE, WStyle_Maximize )
{
  QString buttonPix;

  QBoxLayout *topLayout = new QVBoxLayout(this, 5);
  QGridLayout *grid1Layout = new QGridLayout(7, 2);
  QGridLayout *grid2Layout = new QGridLayout(5, 2);
  QBoxLayout *gridBoxLayout = new QHBoxLayout();
  QBoxLayout *listallLayout = new QHBoxLayout();
  QBoxLayout *listallButtonLayout = new QVBoxLayout();
  QBoxLayout *gridButtonLayout = new QVBoxLayout();
  QBoxLayout *buttonBoxLayout = new QHBoxLayout();
  QBoxLayout *buttonLayout = new QHBoxLayout();
  
  topLayout->addLayout(gridBoxLayout, 0);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );
  
  
  listall = new KTabListBox( this, "User_1",5,0);
  listall->setMinimumSize( 515, 120 );
  listall->setSeparator('\n');
  listall->setColumn(0,i18n("Owner"),50);
  listall->setColumn(1,i18n("Type"),50);
  listall->setColumn(2,i18n("Val1"),30);
  listall->setColumn(3,i18n("String1"),50);
  listall->setColumn(4,i18n("String2"),50);
  listall->clearTableFlags(Tbl_hScrollBar);
  listall->clearTableFlags(Tbl_autoHScrollBar);
  listall->setTableFlags(Tbl_autoVScrollBar);        
  
  topLayout->addLayout(gridBoxLayout, 0);
  topLayout->addLayout(listallLayout, 10);
  topLayout->addLayout(buttonLayout, 0);

  listallLayout->addWidget(listall, 10);
  listallLayout->addLayout(listallButtonLayout,0);

  gridBoxLayout->addLayout(grid1Layout, 0);
  gridBoxLayout->addSpacing(10);
  gridBoxLayout->addLayout(gridButtonLayout, 1);
  gridBoxLayout->addSpacing(5);

  gridButtonLayout->addLayout(grid2Layout, 10);
  gridButtonLayout->addLayout(buttonBoxLayout, 0);

  buttonLayout->addStretch(10);
  buttonBoxLayout->addStretch(10);
  grid1Layout->setColStretch(1, 10);
  //  grid2Layout->setColStretch(0, 5);

  Label_1 = new QLabel(i18n("Domain :"), this);
  Label_1->setMinimumSize(Label_1->sizeHint());
  Label_1->setFont( font );
  grid1Layout->addWidget(Label_1, 0, 0);

  domainedit = new QLineEdit(this);
  domainedit->setMinimumSize( 120, 20 );
  domainedit->setFont( font );
  grid1Layout->addWidget(domainedit, 0, 1);

  Label_2 = new QLabel(i18n("Responsible Person :"), this);
  Label_2->setMinimumSize(Label_2->sizeHint());
  Label_2->setFont( font );  
  grid1Layout->addWidget(Label_2, 1, 0);

  rpedit = new QLineEdit(this);
  rpedit->setMinimumSize( 120, 20 );
  rpedit->setFont( font );
  grid1Layout->addWidget(rpedit, 1, 1);
  
  Label_3 = new QLabel(i18n("Serial :"), this);
  Label_3->setMinimumSize(Label_3->sizeHint());
  Label_3->setFont( font );
  grid1Layout->addWidget(Label_3, 2, 0);
  
  serialedit = new QLineEdit(this);
  serialedit->setMinimumSize( 120, 20 );
  serialedit->setFont(font);
  grid1Layout->addWidget(serialedit, 2, 1);
	
  Label_4 = new QLabel(i18n("Refresh :"), this);
  Label_4->setMinimumSize(Label_4->sizeHint());
  Label_4->setFont( font );
  grid1Layout->addWidget(Label_4, 3, 0);

  refreshedit = new QLineEdit(this);
  refreshedit->setMinimumSize( 120, 20 );
  refreshedit->setFont( font );
  grid1Layout->addWidget(refreshedit, 3, 1);
  
  Label_5 = new QLabel(i18n("Retry :"), this);
  Label_5->setMinimumSize(Label_5->sizeHint());
  Label_5->setFont( font );
  grid1Layout->addWidget(Label_5, 4, 0);
  
  retryedit = new QLineEdit(this);
  retryedit->setMinimumSize( 120, 20 );
  retryedit->setFont( font );
  grid1Layout->addWidget(retryedit, 4, 1);
  
  Label_6 = new QLabel(i18n("Expire :"), this);
  Label_6->setMinimumSize(Label_6->sizeHint());
  Label_6->setFont( font );
  grid1Layout->addWidget(Label_6, 5, 0);
  
  expireedit = new QLineEdit(this);
  expireedit->setMinimumSize( 120, 20 );
  expireedit->setFont(font);
  grid1Layout->addWidget(expireedit, 5, 1);
  
  Label_7 = new QLabel(i18n("Time to live :"), this);
  Label_7->setMinimumSize(Label_7->sizeHint());
  Label_7->setFont( font );
  grid1Layout->addWidget(Label_7, 6, 0);
  
  ttledit = new QLineEdit(this);
  ttledit->setMinimumSize( 120, 20 );
  ttledit->setFont( font );
  grid1Layout->addWidget(ttledit, 6, 1);

  owneredit1 = new QLineEdit(this);
  owneredit1->setMinimumSize( 120, 20 );
  grid2Layout->addWidget(owneredit1, 1, 1);

  ComboType = new QComboBox(FALSE, this);
  ComboType->setMinimumSize( 120, 20 );
  ComboType->setSizeLimit( 10 );
  ComboType->setAutoResize( FALSE );    
  grid2Layout->addWidget(ComboType, 0 ,1);
  
  MXedit = new QLineEdit( this);
  MXedit->setMinimumSize( 120, 20 );
  MXedit->setMaxLength( 255 );
  grid2Layout->addWidget(MXedit, 2, 1);
	
  str2edit = new QLineEdit( this);
  str2edit->setMinimumSize( 120, 20 );
  grid2Layout->addWidget(str2edit, 4, 1);
  
  str1edit = new QLineEdit( this);
  str1edit->setMinimumSize( 140, 20 );
  grid2Layout->addWidget(str1edit, 3, 1);

  Label_8 = new QLabel(i18n("Add / Change :"), this);
  Label_8->setMinimumSize(Label_8->sizeHint());
  Label_8->setFont( font );
  grid2Layout->addWidget(Label_8, 0, 0);
	
  Label_9 = new QLabel(i18n("Owner :"), this);
  Label_9->setMinimumSize(Label_9->sizeHint());
  Label_9->setFont( font );
  grid2Layout->addWidget(Label_9, 1, 0);
  
  MXlabel = new QLabel(i18n("MX Value :"), this);
  MXlabel->setMinimumSize(MXlabel->sizeHint());
  MXlabel->setFont( font );
  grid2Layout->addWidget(MXlabel, 2, 0);

  str1label = new QLabel(i18n("Mail Server :"), this);
  str1label->setMinimumSize(str1label->sizeHint());
  str1label->setFont( font );
  grid2Layout->addWidget(str1label, 3, 0);

  str2label = new QLabel(i18n("Text 2:"), this);
  str2label->setMinimumSize(str2label->sizeHint());
  str2label->setFont( font );
  grid2Layout->addWidget(str2label, 4, 0);
  
  ComboType->insertItem( "MX" );
  ComboType->insertItem( "CNAME" );
  ComboType->insertItem( "A" );
  ComboType->insertItem( "PTR" );
  ComboType->insertItem( "HINFO" );
  ComboType->insertItem( "TXT" );
  ComboType->insertItem( "NS" );
  ComboType->insertItem( "WKS" );
  ComboType->insertItem( "RP" );
  ComboType->insertItem( "AFSDB" );
  
  upButton = new QPushButton(this);
  buttonPix.append((const char *)KApplication::kde_toolbardir());
  buttonPix.append("/up.xpm");
  upButton->setPixmap( QPixmap((const char *)buttonPix) );
  upButton->setMinimumSize(upButton->sizeHint());
  listallButtonLayout->addWidget(upButton, 0);

  downButton = new QPushButton(this);
  buttonPix.replace(QRegExp("up"),"down");
  downButton->setPixmap( QPixmap((const char *)buttonPix) );
  downButton->setMinimumSize(downButton->sizeHint());
  listallButtonLayout->addWidget(downButton, 0);

  patternButton = new QPushButton(i18n("Insert Pattern"), this);
  patternButton->setMinimumSize(patternButton->sizeHint());
  buttonBoxLayout->addWidget(patternButton, 0);
  // patternButton->setEnabled(FALSE);

  addButton = new QPushButton(i18n("Insert"), this);
  addButton->setMinimumSize(addButton->sizeHint());
  buttonBoxLayout->addWidget(addButton, 0);

  changeButton = new QPushButton(i18n("Change"), this);
  changeButton->setMinimumSize(changeButton->sizeHint());
  buttonBoxLayout->addWidget(changeButton, 0);

  deleteButton = new QPushButton(i18n("Delete"), this);
  deleteButton->setMinimumSize(deleteButton->sizeHint());
  buttonBoxLayout->addWidget(deleteButton, 0);

  deleteButton->setEnabled(false);

  closeButton = new QPushButton(i18n("Close"), this);
  closeButton->setMinimumSize(closeButton->sizeHint());
  buttonLayout->addWidget(closeButton, 0);

  connect( ComboType, SIGNAL(activated(const char *)),SLOT(combochange(const char *)));
  
  str2edit->setEnabled(false);
  
  // setMinimumSize(sizeHint());

  QString tmp;
  record *rl;
  int count;
  
  pd = pl;
  domainedit->setText(pl->domain);
  rpedit->setText(pl->rp);
  tmp.sprintf("%u",pl->serial);
  serialedit->setText(tmp);
  tmp.sprintf("%u",pl->refresh);
  refreshedit->setText(tmp);
  tmp.sprintf("%u",pl->retry);
  retryedit->setText(tmp);
  tmp.sprintf("%u",pl->TTL);
  ttledit->setText(tmp);
  tmp.sprintf("%u",pl->expire);
  expireedit->setText(tmp);
  listall->setSeparator('\n');
  listall->setNumCols(5);
  listall->setColumn(0,"Owner",100);
  listall->setColumn(1,"Type",50);
  listall->setColumn(2,"Val1",30);
  listall->setColumn(3,"String1",150);
  listall->setColumn(4,"String2",100);
  listall->clearTableFlags(Tbl_hScrollBar);
  listall->clearTableFlags(Tbl_autoHScrollBar);
  listall->setTableFlags(Tbl_autoVScrollBar);   
  for (rl=pl->data->first();rl!=0;rl=pl->data->next()) 
    {
      tmp.sprintf("%u",rl->i);
      if(rl->owner == "" || rl->owner == 0) 
	{
	  count =  listall->numRows();
	  listall->insertItem("");
	  listall->changeItemPart("", count, 0);
	  listall->changeItemPart(TYPES[rl->type], count, 1);
	  listall->changeItemPart(tmp, count, 2);
	  listall->changeItemPart(rl->st1, count, 3);
	  listall->changeItemPart(rl->st2, count, 4);
	}
      else 
	{
	  tmp=rl->owner+"\n"+TYPES[rl->type]+"\n"+tmp+"\n"+rl->st1+"\n"+rl->st2;
	  listall->insertItem(tmp);
	}
    }
  connect(listall,SIGNAL(selected(int,int)),SLOT(listclick(int,int)));   
  connect(listall,SIGNAL(highlighted(int,int)),SLOT(listhigh(int,int)));
  connect( changeButton, SIGNAL(clicked()), SLOT(changerecord())); 
  connect( addButton,SIGNAL(clicked()),SLOT(addrecord()));
  connect( deleteButton,SIGNAL(clicked()),SLOT(deleterecord()));
  connect( closeButton,SIGNAL(clicked()),SLOT(closeButtonClicked()));
  connect( upButton,SIGNAL(clicked()),SLOT(upButtonClicked()));
  connect( downButton,SIGNAL(clicked()),SLOT(downButtonClicked()));
  connect( patternButton,SIGNAL(clicked()),SLOT(patternButtonClicked()));
  listsel = -1;

  topLayout->activate();
  setCaption(i18n("Primary Domain"));
  hasChanged = false;

}


ksoaedit::~ksoaedit()
{
}

void ksoaedit::patternButtonClicked()
{
  hasChanged = true;
  patternDialog *pat = new patternDialog(pd, listsel, this, "pattern");
  pat->show();
  
  record *rl;
  QString tmp;
  int count;

  listall->clear();
  for (rl=pd->data->first();rl!=0;rl=pd->data->next()) 
    {
      tmp.sprintf("%u",rl->i);
      if(rl->owner == "" || rl->owner == 0) 
	{
	  count =  listall->numRows();
	  listall->insertItem("");
	  listall->changeItemPart("", count, 0);
	  listall->changeItemPart(TYPES[rl->type], count, 1);
	  listall->changeItemPart(tmp, count, 2);
	  listall->changeItemPart(rl->st1, count, 3);
	  listall->changeItemPart(rl->st2, count, 4);
	}
      else 
	{
	  tmp=rl->owner+"\n"+TYPES[rl->type]+"\n"+tmp+"\n"+rl->st1+"\n"+rl->st2;
	  listall->insertItem(tmp);
	}
    }

}

void ksoaedit::closeButtonClicked()
{
  record *rl;
  QString tmp;
  rl=pd->data->first();
  if ( rl != 0 )
    {
      if(TYPES[rl->type] != "NS") 
	QMessageBox::warning( this, i18n("Warning"), i18n("You should have a NS record as your first record."));
    }
  incser();

  pd->domain = domainedit->text();
  pd->rp=rpedit->text();
  // tmp.sprintf("%u",pl->refresh);
  tmp=refreshedit->text();
  pd->refresh=tmp.toUInt();
  // tmp.sprintf("%u",pl->retry);
  tmp=retryedit->text();
  pd->retry=tmp.toUInt();
  // tmp.sprintf("%u",pl->TTL);
  tmp=ttledit->text();
  pd->TTL=tmp.toUInt();
  // tmp.sprintf("%u",pl->expire);
  tmp=expireedit->text();
  pd->expire=tmp.toUInt();

  done(0);
}

void ksoaedit::upButtonClicked()
{
  hasChanged = true;
  QString tmp;
  record *rl;
  
  if (listsel > 0) 
    {
      tmp = listall->text( listsel );
      
      rl = pd->data->take( listsel );
      pd->data->insert( listsel - 1, rl);
      
      listall->changeItem(listall->text( listsel - 1 ), listsel );
      listall->changeItem( ( const char * )tmp, listsel - 1 );
      
      listall->unmarkAll();
      listsel--;
      listall->markItem( listsel );
    }
}

void ksoaedit::downButtonClicked()
{
  hasChanged = true;
  QString tmp;
  record *rl;

  if ( listsel < ( listall->numRows() - 1 ) ) 
    {
      tmp = listall->text( listsel );
      
      rl = pd->data->take( listsel );
      pd->data->insert( listsel + 1, rl);
      
      listall->changeItem(listall->text( listsel + 1 ), listsel );
      listall->changeItem( ( const char * )tmp, listsel + 1 );
      
      listall->unmarkAll();
      listsel++;
      listall->markItem( listsel );
    }
}

void ksoaedit::changerecord()
{
  hasChanged = true;
  QString tmp,tmp1;
  record *rl;
  int count;
  
  if (listsel != -1) 
    {
      rl = new record;
      rl->owner = owneredit1->text();
      tmp1=MXedit->text();
      for(count=0; strcmp(ComboType->currentText(),TYPES[count]);count++);
      rl->type = count;
      rl->i    = tmp1.toInt();
      rl->st1   = str1edit->text();
      rl->st2   = str2edit->text();
      
      pd->data->remove(listsel);
      pd->data->insert(listsel, rl);
      
      listall->changeItemPart(owneredit1->text(), listsel, 0);
      listall->changeItemPart(listall->text(listsel,1), listsel, 1);
      listall->changeItemPart(tmp1, listsel, 2);
      listall->changeItemPart(str1edit->text(), listsel, 3);
      listall->changeItemPart(str2edit->text(), listsel, 4);
      listall->update();
  }
  
}

void ksoaedit::addrecord()
{
  hasChanged = true;
  QString tmp,tmp1;
  record *rl;
  int n = 0, count = 0;
  
  if(listsel != -1)
    tmp = listall->text(listsel,1);
  
  rl = new record();
  
  for (n=0;n<21;n++) 
    {
    if (strcmp(ComboType->currentText(),TYPES[n]) == 0) 
      {
	rl->type=n;
      }
    }
  rl->owner = owneredit1->text();
  tmp1=MXedit->text();
  rl->i	  = tmp1.toInt();
  rl->st1   = str1edit->text();
  rl->st2   = str2edit->text();
  
  if(listsel != -1) 
    {
      pd->data->insert(listsel, rl);
      count = listsel;
    }
  else
    {
      pd->data->append(rl);
    }

  listall->clear();
  for (rl=pd->data->first();rl!=0;rl=pd->data->next()) 
    {
      tmp.sprintf("%u",rl->i);
      if(rl->owner == "" || rl->owner == 0) 
	{
	  count =  listall->numRows();
	  listall->insertItem("");
	  listall->changeItemPart("", count, 0);
	  listall->changeItemPart(TYPES[rl->type], count, 1);
	  listall->changeItemPart(tmp, count, 2);
	  listall->changeItemPart(rl->st1, count, 3);
	  listall->changeItemPart(rl->st2, count, 4);
	}
      else 
	{
	  tmp=rl->owner+"\n"+TYPES[rl->type]+"\n"+tmp+"\n"+rl->st1+"\n"+rl->st2;
	  listall->insertItem(tmp);
	}
    }
}

void ksoaedit::deleterecord()
{
  // record *rl;
  int count;
  hasChanged = true;
  QString tmp,tmp1;
  count = listsel;
  
  pd->data->remove(listsel);
  
  listall->changeItemPart("", count, 0);
  listall->changeItemPart("", count, 1);
  listall->changeItemPart("", count, 2);
  listall->changeItemPart("", count, 3);
  listall->changeItemPart("", count, 4);
  listall->removeItem(count);
  deleteButton->setEnabled(false);
  listsel = -1;

}

void ksoaedit::incser()
{
  if(hasChanged) {
    QString tmp;
    QDate todate;
    int today = 0;
    todate = QDate::currentDate();
    today = (todate.year() * 1000000 + 
	     todate.month() * 10000 + 
	     todate.day() * 100);
    if((pd->serial - today) > 0 && (pd->serial - today) < 99) {
      pd->serial++;
    }
    if(pd->serial - today > 99) {
      printf("Warning, to many changes this day...");
    }
    if(pd->serial - today < 0) {
      pd->serial = today + 1;
    }  
    tmp.sprintf("%u",pd->serial);
    serialedit->setText(tmp);
  }
}


void ksoaedit::combochange(const char * txt)
{
  if (strcmp(txt,"NS") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Name Server:"));
    str2edit->setEnabled(false);   
  } 
  if (strcmp(txt,"A") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Adress :" ));
    str2edit->setEnabled(false);   
  }

  if (strcmp(txt,"WKS") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Adress :"));
    str2label->setText(i18n("Protocol :"));
    str2edit->setEnabled(true);   
  }

  if (strcmp(txt,"RP") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("MBox Domain-name :"));
    str2label->setText(i18n("TXT Domain-name :"));
    str2edit->setEnabled(true);   
  }

  if (strcmp(txt,"AFSDB") == 0) {
    MXedit->setEnabled(true);
    MXlabel->setText(i18n("Subtype :"));
    str1label->setText(i18n("Hostname :"));
    str2edit->setEnabled(false);   
  }

  if (strcmp(txt,"PTR") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Pointer to adress :"));
    str2edit->setEnabled(false);   
  }
  
  if (strcmp(txt,"HINFO") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Hardware :"));
    str2label->setText(i18n("OS :"));
    str2edit->setEnabled(true);   
  }
  if (strcmp(txt,"TXT") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Text :"));
    str2edit->setEnabled(false);   
  }
  
  if (strcmp(txt,"CNAME") == 0) {
    MXedit->setEnabled(false);
    str1label->setText(i18n("Alias :"));
    str2edit->setEnabled(false);   
  }
  
  if (strcmp(txt,"MX") == 0) {
    MXedit->setEnabled(true);
    MXlabel->setText(i18n("MX Value :"));
    str1label->setText(i18n("Mail Server :"));
    str2edit->setEnabled(false);   
  }
  //  str1label->setMinimumSize(str1label->sizeHint());
}

void ksoaedit::listhigh(int index, int)
{
  if(listsel != index) {
    listsel = index;
    deleteButton->setEnabled(true);
  } else {
    listsel = -1;
    deleteButton->setEnabled(false);
    listall->unmarkAll();
  }
}

void ksoaedit::listclick(int index,int col)
{
  QString tmp;
  int a,b,c;
  c=col;c=0;
  listsel = index;
  tmp = listall->text(index,1);
  a = ComboType->count();
  for (b=0;b<a;b++) {
    if (strcmp(tmp,ComboType->text(b))==0) c=b;
  }
  ComboType->setCurrentItem(c);
  combochange(tmp);
  tmp=listall->text(index,0);
  owneredit1->setText(tmp);
  tmp=listall->text(index,2);
  MXedit->setText(tmp);
  tmp=listall->text(index,3);
  str1edit->setText(tmp);
  tmp=listall->text(index,4);
  str2edit->setText(tmp);
         
}
