#include <iostream.h>
#include "ircClient.h"
#include "StringToken.h"
#include "lineDialog.h"
#include "CmdParser.h"

#ifdef TCL
#include "onTclPage.h"
#endif

#include "ircDefine.h"
#include "ircApp.h"

CmdTab CmdParser::cmdTab[]={
    {"CTCP",      CmdParser::cmdCtcp },
    {"DCC",       CmdParser::cmdDCC  },
    {"PRIVMSG",   CmdParser::cmdPrivMsg },
    {"NOTICE",    CmdParser::cmdNotice },
    {"BROWSER",   CmdParser::cmdBrowser},
    {"ADDPAGE",   CmdParser::cmdAddPage},
    {"DELPAGE",   CmdParser::cmdDelPage},
    {"ADDFRIEND", CmdParser::cmdAddFriend},
    {"DELFRIEND", CmdParser::cmdDelFriend},
    {"ADDBAN",    CmdParser::cmdAddBan},
    {"DELBAN",    CmdParser::cmdDelBan},
    {"ADDIGNORE", CmdParser::cmdAddIgnore},
    {"DELIGNORE", CmdParser::cmdDelIgnore},
    {"TCL",       CmdParser::cmdTcl    },
    {"SHOW",      CmdParser::cmdShow   },
    {"SERVER",    CmdParser::cmdServer   },
    {"LOAD",      CmdParser::cmdLoad   },
    {NULL,        NULL}
};

CmdParser::CmdParser(QObject* Parent, const char* Name):
  QObject(Parent, Name)
{
  client = (IrcClient*)Parent;
}

// return 0 -> socket->parseLine
// return 1 -> ok
int CmdParser::parseLine(const char* from, const char* txt)
{
  StringToken token(txt," ");
  QString cmd, rest; 

  // :from cmd
  // cmd
#ifdef EDEBUG
  cout << txt << endl;
#endif

  cmd  = token.nextToken();
  rest = token.toEnd("\n");

  for (int i=0;cmdTab[i].name!=NULL;i++){
    if (!stricmp(cmd, cmdTab[i].name)){
       return (this->*(cmdTab[i].func))(from, rest);
    }
  }
  return 0;
}

// DCC CHAT to     , DCC CHAT
// DCC SEND to file, DCC SEND file
int CmdParser::cmdDCC(const char* from, const char* txt)
{
  StringToken ft(from);
  StringToken tt(txt);
  QString art =tt.nextToken();
  QString to;

  int argc = tt.countTokens();

  if (!stricmp(art, "CHAT")){
     if (argc==0)
        to = ft.nextToken(" ~!");
     else
        to = tt.nextToken();
     if (to.isEmpty() || to[0]=='#' || to[0]=='&')
        return 1;
     client->addDCCChat(to, 0L, MDI_SHOW);
     return 1;
  }
  else if (!stricmp(art, "SEND")){
     QString file;
     if (argc==0){
        client->dccFileDlg->show();
        return 1;
     }
     else if (argc==1){
        to = tt.nextToken();
        client->dccFileDlg->show(to);
	return 1;
     }
     else{
        to   = tt.nextToken();
	file = tt.nextToken();
     }
     if (to.isEmpty() || to[0]=='#' || to[0]=='&' || file.isEmpty())
        return 1;
     client->addDCCFile(to, file, MDI_SHOW);
     return 1;
  }
  return 0;
}



int CmdParser::cmdCtcp(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdCtcp:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  =tt.nextToken();
  QString cmd =tt.nextToken();
  QString nick=ft.nextToken(" !~");

  if (to.isEmpty())
     return 1;
  ClientCore* cc;
  if (to[0]=='#' || to[0]=='&')
     cc = client->channel->find(to);
  else
     cc = client->privMsg->find(to);
  QString s="";
  if (!stricmp(cmd, "ACTION") && cc){
     s += "ACTION ";
     s += tt.toEnd();
     cc->onMsg(client->currentNick(), s);
     return 0;
  }
  else if (!stricmp(cmd, "SOUND")){
     QString file = tt.nextToken();
     if (file.isNull() || file.isEmpty()){
        client->mediaDlg->show(to);
	return 1;
     }
  }
  else if (!stricmp(cmd, "DCC")){
     QString art=tt.nextToken();
     return parseLine(from, cmd+" "+art+" "+to+" "+tt.toEnd());
  }
  cmd = cmd.upper();
  s += 0x02;
  s += QString("[")+cmd+QString("]");
  s += 0x02;
  s += QString(" ")+to;
  client->slotWriteOnActive(TYPE_CTCP, s);
  return 0; 
}

int CmdParser::cmdPrivMsg(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdPrivMsg:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  =tt.nextToken();
  QString tx  =tt.toEnd("\n");
  QString nick=ft.nextToken(" !");

  tx.remove(0, 1);
  if (to.isEmpty())
     return 1;

  if (to[0]=='#' || to[0]=='&'){
     IrcChannel* ic;
     if ((ic=client->channel->find(to))!=0L)
        ic->onMsg(client->currentNick(), tx);
     else{
        QString s="";
	s +=0x02;
	s +=QString("<")+client->currentNick()+":"+to+QString(">");
	s +=0x02;
	s += " "+tx;
        client->slotWriteOnActive(TYPE_TEXT, s);
     }
     return 0;
  }
  else {
     IrcPrivMsg* ip;
     if ((ip=client->privMsg->find(to))!=0L) {
        ip->onMsg(client->currentNick(), tx);
	return 0;
     }
     else{
        client->addPrivMsg(to, MDI_SHOW);
	if ((ip=client->privMsg->find(to)) && (!tx.isEmpty())){
	   ip->onMsg(client->currentNick(), tx);
	   return 0;
	}
	else
	   return 1;
     }
  }
  return 0;
}

int CmdParser::cmdNotice(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdNotice:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  =tt.nextToken();
  QString tx  =tt.toEnd("\n");
  QString nick=ft.nextToken(" !");

  if (to.isEmpty())
     return 1;

  QString s="";
  s += 0x02;
  s += QString("=")+client->currentNick()+":"+to+QString("=");
  s += 0x02;
  s += " "+tx;

  if (to[0]=='#' || to[0]=='&'){
     IrcChannel* ic;
     if ((ic=client->channel->find(to))!=0L)
        ic->slotWriteMsg(TYPE_TEXT, s);
     else
        client->slotWriteOnActive(TYPE_TEXT, s);
     return 0;
  }
  else {
     IrcPrivMsg* ip;
     if ((ip=client->privMsg->find(to))!=0L){
        ip->slotWriteMsg(TYPE_TEXT, s);
	return 0;
     }
     else{
        client->slotWriteOnActive(TYPE_TEXT, s);
	return 0;
     }
  }
  return 0;
}

int CmdParser::cmdPart(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdPart:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  =tt.nextToken();
  QString who =ft.nextToken(" !~");

  if (to.isEmpty()){
     if (!who.isEmpty() && (who[0]=='#' || who[0]=='&'))
        to = who;
     else
        return 1;
  }

  if (client->getSocket().getSocket()<0)
     client->delChannel(to);
  return 0;
}

int CmdParser::cmdBrowser(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdBrowser:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString cmd = tt.nextToken();
  QString who = ft.nextToken(" !~");

  if (cmd.isEmpty()){
     SingleDialog dlg("Command:", "","Type command");
     if (dlg.exec()){
        QString cmd=dlg.getText(TRUE);
	if (cmd.isEmpty())
	   return 1;
     }
  }
  ircapp->browse(cmd);
  return 1;
}

int CmdParser::cmdAddPage(const char*, const char* txt)
{
  StringToken tt(txt);
  QString name   = tt.nextToken();
  QString flag   = tt.nextToken();
  QString detach = tt.nextToken();

  if (name.isEmpty())
     return 1;
  int id = detach.toInt();
  if (id>0)
     client->addOutputPage(name, flag.toInt(), true);
  else
     client->addOutputPage(name, flag.toInt(), false);
  return 1;
}

int CmdParser::cmdDelPage(const char*, const char* txt)
{
  StringToken tt(txt);
  QString name   = tt.nextToken();

  if (name.isEmpty())
     return 1;
  client->delOutputPage(name);
  return 1;
}

int CmdParser::cmdAddFriend(const char*, const char* txt)
{
  StringToken tt(txt);
  QString k = tt.nextToken();
  QString l = tt.nextToken();
  QString c = tt.nextToken();

  if (k.isEmpty() || l.isEmpty())
     return 1;
  client->friendList->addUser(k, l.toInt(), c);
  return 1;
}

int CmdParser::cmdDelFriend(const char*, const char* txt)
{
  StringToken tt(txt);
  QString k = tt.nextToken();

  if (k.isEmpty())
     return 1;
  client->friendList->delUser(k);
  return 1;
}

int CmdParser::cmdAddBan(const char*, const char* txt)
{
  StringToken tt(txt);
  QString k = tt.nextToken();
  QString l = tt.nextToken();
  QString c = tt.nextToken();

  if (k.isEmpty() || l.isEmpty())
     return 1;
  client->banList->addUser(k, l.toInt(), c);
  return 1;
}

int CmdParser::cmdDelBan(const char*, const char* txt)
{
  StringToken tt(txt);
  QString k = tt.nextToken();

  if (k.isEmpty())
     return 1;
  client->banList->delUser(k);
  return 1;
}

int CmdParser::cmdAddIgnore(const char*, const char* txt)
{
  StringToken tt(txt);
  QString k = tt.nextToken();
  QString l = tt.nextToken();
  QString c = tt.nextToken();

  if (k.isEmpty() || l.isEmpty())
     return 1;
  client->ignList->addUser(k, l, c.toULong());
  return 1;
}

int CmdParser::cmdDelIgnore(const char*, const char* txt)
{
  StringToken tt(txt);
  QString k = tt.nextToken();

  if (k.isEmpty())
     return 1;
  client->ignList->delUser(k);
  return 1;
}

int CmdParser::cmdTcl(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdTcl:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString cmd =tt.nextToken();
  QString argv=tt.toEnd();
  QString who =ft.nextToken(" !~");
#ifdef TCL
  client->tclCmd->evalCmd(cmd, argv);
#endif
  return 1;
}

int CmdParser::cmdShow(const char*, const char* txt)
{
#ifdef EDEBUG
  cout << "CmdParser::cmdShowl:"<<from<<":"<<txt<<endl;
#endif
  StringToken tt(txt);
  QString name =tt.nextToken();
  
  QWidget* w=client->dlgList->find(name);
  if (w!=0L)
     w->show();

  return 1;
}

int CmdParser::cmdServer(const char*, const char* txt)
{
  StringToken tt(txt);
  QString s = tt.nextToken();
  QString p = tt.nextToken();
  QString a = tt.nextToken();
  QString i = tt.toEnd();
  if (s.isEmpty())
     s="";
  if (p.isEmpty())
     p="";
  if (a.isEmpty())
     a="";
  if (i.isEmpty())
     i="";

  client->setCurServer(s+":"+p+":"+a+":"+i);
  client->slotConnect (0L);

  return 1;
}

int CmdParser::cmdLoad(const char*, const char* txt)
{
  StringToken tt(txt);
  QString s = tt.nextToken();
  if (s.isEmpty())
     return 1;

#ifdef TCL
  OnTclPage* tcl=(OnTclPage*)client->optPrefDlg->getPage("Loading Tcl Script");
  tcl->loadTcl(s);
#endif

  return 1;
}

#include "CmdParser.moc"
