#include <iostream.h>
#include <qfileinf.h> 
#include <qfile.h>
#include "colorOpt.h"
#include <kcolordlg.h> 
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include <qbuttongroup.h> 
#include "kcolorbtn.h"
#include "ircDefine.h"
#include "ircApp.h"

int  IrcColor::count=0;
QColor IrcColor::color[];

ColorButton::ColorButton(const QColor& color, const char* s, QWidget* p, const char* name)
  : QPushButton(p, name)
{
  label = new QLabel(this);
  label->setAlignment(AlignHCenter|AlignVCenter);
  if (s!=0L)
     label->setText(s);
  label->installEventFilter(this);
  label->setBackgroundColor(color);
}

bool ColorButton::eventFilter ( QObject *, QEvent *e )
{
    if (e->type() == Event_MouseButtonPress)
        QPushButton::mousePressEvent( (QMouseEvent *)e );
    else if (e->type() == Event_MouseButtonRelease)
        QPushButton::mouseReleaseEvent( (QMouseEvent *)e );
   
    return false;
}

void ColorButton::resizeEvent(QResizeEvent* e)
{
  label->setGeometry(1,
		     1,
		     width()-2,
		     height()-2);
}


IrcColor::IrcColor(QWidget* parent, const char* name, WFlags f) :
  QWidget(parent, name, f)
{
  QButtonGroup*  bg = new QButtonGroup(this);
  connect(bg, SIGNAL(clicked(int)),
	  SLOT(slotClicked(int)));

  QVBoxLayout* vlayout = new QVBoxLayout(bg, 0);

  if (count<1)
     readConfig();
  count++;

  btnList.setAutoDelete(false);
  QBoxLayout*  hbox;

  int i, j;
  QString s;
  for (i=0;i<2;i++){
     hbox    = new QHBoxLayout;
     vlayout->addLayout(hbox);
     for (j=0;j<8;j++){
       s.setNum(i*8+j);
       ColorButton* btn;
       btnList.append(btn=new ColorButton(color[i*8+j], s, bg));
       hbox->addWidget(btn);
       btn->setFixedSize(20,20);
     }
  }
  vlayout->activate();
}

void IrcColor::readConfig()
{
  KConfig *config = ircapp->config;
  
  color[0]    = config->readColorEntry( "IrcColor0",    &black);
  color[1]    = config->readColorEntry( "IrcColor1",    &white);
  color[2]    = config->readColorEntry( "IrcColor2",    &darkGray);
  color[3]    = config->readColorEntry( "IrcColor3",    &gray);
  color[4]    = config->readColorEntry( "IrcColor4",    &lightGray);
  color[5]    = config->readColorEntry( "IrcColor5",    &red);
  color[6]    = config->readColorEntry( "IrcColor6",    &green);
  color[7]    = config->readColorEntry( "IrcColor7",    &blue);
  color[8]    = config->readColorEntry( "IrcColor8",    &cyan);
  color[9]    = config->readColorEntry( "IrcColor9",    &magenta);
  color[10]   = config->readColorEntry( "IrcColor10",   &yellow);
  color[11]   = config->readColorEntry( "IrcColor11",   &darkRed);
  color[12]   = config->readColorEntry( "IrcColor12",   &darkGreen);
  color[13]   = config->readColorEntry( "IrcColor13",   &darkBlue);
  color[14]   = config->readColorEntry( "IrcColor14",   &darkCyan);
  color[15]   = config->readColorEntry( "IrcColor15",   &darkMagenta);

}

void IrcColor::slotClicked(int id)
{
  int result = KColorDialog::getColor(color[id]); 
  if (result){
     QString s;s.setNum(id);
     btnList.at(id)->setBackgroundColor(color[id]);
     ircapp->writeEntry("IrcColor"+s, color[id]);
     emit signChanged(id, color[id]);
  }
}

IrcColorDlg::IrcColorDlg(QWidget* parent, const char* name, WFlags f)
  : IrcColor(parent, name, f)
{
  resize(160, 40);
}

void IrcColorDlg::setBgColor()
{
  for (int id=0;id<16;id++)
     btnList.at(id)->setBackgroundColor(IrcColor::color[id]);
}

void IrcColorDlg::slotClicked(int)
{
}

ColorOpt::ColorOpt( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QHBoxLayout* horLayout  = new QHBoxLayout(this, 10);
  QVBoxLayout* lVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(lVerLayout, 0);

  QGroupBox* gb;
  QVBoxLayout* vlayout;
  QBoxLayout*  hlayout;

  gb   = new QGroupBox("Color Options", this);
  lVerLayout->addWidget(gb);
  readOptions();
  KColorButton *colorBtn;
  QLabel *label;
  vlayout = new QVBoxLayout(gb, 10);
  vlayout->addSpacing(gb->fontMetrics().height());

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Background Color:"), gb);
  hlayout->addWidget(label);
  label->setFixedSize(100,25);

  colorBtn = new KColorButton( bgColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotBgColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Text Color:"), gb );
  hlayout->addWidget(label);
  label->setFixedSize(100, 25);
  colorBtn = new KColorButton( textColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotTextColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Info Color:"), gb );
  hlayout->addWidget(label);
  label->setFixedSize(100, 25);

  colorBtn = new KColorButton( infoColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotInfoColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Message Color:"), gb );
  hlayout->addWidget(label);
  label->setFixedSize(100, 25);

  colorBtn = new KColorButton( msgColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotMsgColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Error Color:"), gb );
  hlayout->addWidget(label);
  label->setFixedSize(100, 25);

  colorBtn = new KColorButton( errorColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotErrorColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Action Color:"), gb );
  hlayout->addWidget(label);
  label->setFixedSize(100, 25);

  colorBtn = new KColorButton( actionColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotActionColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Background MDI:"), gb );
  hlayout->addWidget(label);
  label->setFixedSize(100, 25);

  colorBtn = new KColorButton( bgMDIColor, gb );
  connect( colorBtn, SIGNAL( changed( const QColor & ) ),
	   SLOT( slotBgMDIColorChanged( const QColor & ) ) );
  hlayout->addWidget(colorBtn);
  colorBtn->setFixedSize(80,25);

  vlayout->activate();

  lVerLayout->addSpacing(10);

  QGroupBox* gbCol = new QGroupBox("Irc Color", this);
  lVerLayout->addWidget(gbCol);

  vlayout = new QVBoxLayout(gbCol, 10);
  vlayout->addSpacing(gbCol->fontMetrics().height());

  IrcColor* ic=new IrcColor(gbCol);
  vlayout->addWidget(ic);
  ic->setFixedSize(180, 50);

  vlayout->addStretch(10);
  vlayout->activate();


  // background
  QVBoxLayout* rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout, 10);

  gb   = new QGroupBox("Background MDI Image", this);
  rVerLayout->addWidget(gb);
  vlayout = new QVBoxLayout(gb, 10);
  vlayout->addSpacing(gb->fontMetrics().height());
  pathEdit = new QLineEdit(gb);
  vlayout->addWidget(pathEdit);
  pathEdit->setFixedHeight(25);

  fileBox = new FileBox(gb, "fileBox", "*.jpg:*.gif:");
  vlayout->addWidget(fileBox, 10);

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  QPushButton* btn;
  btn = new QPushButton(" Apply ", gb);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  hlayout->addWidget(btn);
  btn->setFixedHeight(25);
  btn = new QPushButton(" Delete ", gb);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  hlayout->addWidget(btn);
  btn->setFixedHeight(25);

  vlayout->activate();

  horLayout->activate();

  readConfig();
  show();
}

ColorOpt::~ColorOpt()
{
#ifdef EDEBUG
  cout << "Destruktor ColorOpt" << endl;
#endif
}

void ColorOpt::readOptions()
{
  KConfig *config = ircapp->config;
  
  bgColor    = config->readColorEntry( "BgColor",    &white );
  textColor  = config->readColorEntry( "TextColor",  &black );
  infoColor  = config->readColorEntry( "InfoColor",  &blue  );
  msgColor   = config->readColorEntry( "MsgColor",   &red   );
  actionColor= config->readColorEntry( "ActionColor",&red   );
  errorColor = config->readColorEntry( "ErrorColor", &red   );
  bgMDIColor = config->readColorEntry( "BgMDIColor",    &lightGray );
}

void ColorOpt::readConfig()
{
  pathbg     = ircapp->readEntry("BackgroundImage", "");
  QString dir;
  if (!strcmp(pathbg, "") || !QFile::exists(pathbg)){
     dir=ircapp->home;
     fileBox->setDir(dir);
  }
  else{
     QFileInfo fi(pathbg);
     dir = fi.dirPath(TRUE);
     fileBox->setDir(dir);
     QString ext="*."+fi.extension();
     fileBox->getFilterBox()->setFilter(ext);
  }
}

void ColorOpt::slotBgColorChanged( const QColor &col )
{
  if ( bgColor != col ){
     bgColor = col;
     ircapp->writeEntry( "BgColor",   bgColor );
     emit colorsChanged( bgColor, TYPE_BG);
  }
}

void ColorOpt::slotBgMDIColorChanged( const QColor &col )
{
  if ( bgColor != col ){
     bgColor = col;
     ircapp->writeEntry( "BgMDIColor",   bgColor );
     emit colorsChanged( bgColor, TYPE_BGMDI);
  }
}

void ColorOpt::slotTextColorChanged( const QColor &col )
{
  if ( textColor != col ){
     textColor = col;
     ircapp->writeEntry( "TextColor",   textColor );
     emit colorsChanged( textColor, TYPE_TEXT);
  }
}
   
void ColorOpt::slotInfoColorChanged( const QColor &col )
{
  if ( infoColor != col ){
     infoColor = col;
     ircapp->writeEntry( "InfoColor",   infoColor );
     emit colorsChanged( infoColor, TYPE_INFO);
  }
}

void ColorOpt::slotMsgColorChanged( const QColor &col )
{
  if ( msgColor != col ){
     msgColor = col;
     ircapp->writeEntry( "MsgColor",   msgColor );
     emit colorsChanged( msgColor, TYPE_MSG);
  }
}

void ColorOpt::slotActionColorChanged( const QColor &col )
{
  if ( actionColor != col ){
     actionColor = col;
     ircapp->writeEntry( "ActionColor",   actionColor );
     emit colorsChanged( actionColor, TYPE_ACTION);
  }
}

void ColorOpt::slotErrorColorChanged( const QColor &col )
{
  if ( errorColor != col ){
     errorColor = col;
     ircapp->writeEntry( "ErrorColor",   errorColor );
     emit colorsChanged( errorColor, TYPE_ERROR);
  }
}

void ColorOpt::slotApply()
{
  QString file = fileBox->selectedFile();
  pathEdit->setText(file);
  if ( pathbg != file ){
     pathbg = file;
     ircapp->writeEntry( "BackgroundImage", pathbg);
     emit bgChanged( pathbg);
  }
}

void ColorOpt::slotDelete()
{
  pathbg="";
  ircapp->writeEntry( "PathBackground", pathbg);
  emit bgChanged( pathbg);
}


#include "colorOpt.moc"
