#include <iostream.h>
#include "StringToken.h"
#include "ircClient.h"
#include "dccChat.h"
#include "dccChat.moc"
#include "ircDefine.h"
#include "ircBell.h"
#include "ircApp.h"


DCCChat::DCCChat(const char* User, const char* ip, const char* port,
		 QObject* Parent,  const char* Name):
  DCCClient(User, Parent, Name)
{
  type = DCC_INCOMING;
  ulong uip = ntohl(QString(ip).toULong());
  InetAddress inAddr(uip);
  host = new IrcServer(inAddr.getHostAddress(), QString(port).toInt());

  connect(host,
	  SIGNAL(signSecTimeout(IrcCore*)),
	  SLOT  (slotConnect   (IrcCore*)));
  host->setCusInterval(1);
  host->start();
}

DCCChat::DCCChat(const char* User, QObject* Parent,  const char* Name):
  DCCClient(User, Parent, Name)
{
#ifdef EDEBUG
  cout << "DCCChat::DCCChat:"<<User<<endl;
#endif
  type = DCC_OUTGOING;

  connect(this,
	  SIGNAL(signCusTimeout(IrcCore*)),
	  SLOT  (slotServe(IrcCore*)));
  setCusInterval(1);
  start();
}

DCCChat::~DCCChat()
{
#ifdef EDEBUG
  cout << "Destruktor DCCChat" << endl;
#endif
}

void DCCChat::slotServe(IrcCore*)
{
#ifdef EDEBUG
  cout << "DCCChat::slotServe:"<<name() << endl;
#endif
  stop();
  disconnect(this,
	     SIGNAL(signCusTimeout(IrcCore*)),
	     this,
	     SLOT  (slotServe(IrcCore*)));

  slotWriteMsg(TYPE_INFO|TYPE_IMG, "Please wait...");
  QString to=user->nick();
  QString host=client->getSocket().getLocalInetAddress().getHostAddress();
  if (server.Open(host)<1){
     slotDisconnected();
     return;
  }
  emit signServe();
  QString as, ps;
  ulong up = htonl(server.getLocalInetAddress().getAddress());
  as.setNum(up);
  ps.setNum(server.getLocalPort());
  QString s="";
  s += to+" DCC CHAT chat "+as+" "+ps;
  client->getSocket().sendCtcp(s);  
  connect(&server,
	  SIGNAL(signAccept(ClientSocket*)),
	  SLOT  (slotAccept(ClientSocket*)));
  int timeout=ircapp->readNumEntry("DCCChatTimeout", 120);
  setCusInterval((ulong)timeout);
  connect(this,
	  SIGNAL(signCusTimeout(IrcCore*)),
	  SLOT  (slotCusTimeout(IrcCore*)));
  start();
}


void DCCChat::slotInputParse(const char* Txt)
{
  QString inp = client->alias->eval(Txt);
  inp = cmdSubstitution(inp);
  //inp = inp.stripWhiteSpace();
  if (inp.isEmpty())
     return;
  if (inp[0] == client->cmdChar[0])
     emit signCommand(name(), inp);
  else
     writeMsg(inp);
}

void DCCChat::slotMsgParse(int sd)
{
#ifdef EDEBUG
  cout << "DCCChat::slotMsgParse:"<<endl;
#endif
  if (sd<1)
     return;
  sn->setEnabled(false);
  QString d(4096);
  if (socket->readLine(d)<1){
     sn->setEnabled(false);
     return;
  } 
  if (d.isNull()){
     if (sn)
        sn->setEnabled(true);
     return;
  }

  IrcBell* ib=client->bell.find("DCCChatBell");
  if (ib)
     ib->slotPlay();

  QString s="";
  s += 0x02;
  s += "="+user->nick()+"=";
  s += 0x02;
  s += " "+d;
  slotWriteMsg(TYPE_DCC, s);
  if (sn)
     sn->setEnabled(true);
}

void DCCChat::writeMsg(const char* Txt)
{
  if (!socket)
     return;
  StringToken tt(Txt);
  QString t=tt.nextToken();

  QString s="";
  s += 0x02;
  if (t=="ACTION"){
     s += mNick+0x02+" "+QString(Txt);
     emit signWriteMsg(TYPE_ACTION, s, 1);
  }
  else{
     s += "<"+mNick+">"+0x02+" ";
     s += Txt;
     emit signWriteMsg(TYPE_TEXT, s, 1);
  }
  socket->writeLine(Txt);
}





