#include <iostream.h>
#include "StringToken.h"
#include "ircClient.h"
#include "dccClient.h"
#include "dccClient.moc"
#include "ircDefine.h"
#include "ircApp.h"

void DCCClient::Init()
{
  socket = NULL;
  host   = NULL;
  user   = NULL;
  state  = 0;
  sn     = NULL;
}

DCCClient::DCCClient(const char* User, QObject* Parent, const char* Name):
  ClientCore(Parent, Name)
{
  DCCClient::Init();
  client = (IrcClient*)Parent;
  if (!User)
     return;
  user    = new IrcUser(User);
  setName(User);
}


DCCClient::~DCCClient()
{
#ifdef EDEBUG
  cout << "Destruktor DCCClient" << endl;
#endif
  delete user;
  delete host;
  delete sn;
  delete socket;
}

QString DCCClient::cmdSubstitution(const char* Txt)
{
  QDict<char> list;
  list.setAutoDelete(true);
  list.insert("$u",    qstrdup(user->nick()));
  list.insert("$to",   qstrdup(user->nick()));
  return ClientCore::cmdSubstitution(list, Txt);
}

void DCCClient::slotServe(IrcCore*)
{
  stop();
  emit signServe();
  QString to=user->nick();
  QString host=client->getSocket().getLocalInetAddress().getHostAddress();
  if (server.Open(host)<1){
     slotDisconnected();
     return;
  }
  connect(&server,
	  SIGNAL(signAccept(ClientSocket*)),
	  SLOT  (slotAccept(ClientSocket*)));
}


void DCCClient::slotConnect(IrcCore* ic)
{
  emit signConnect();
  IrcServer* is=(IrcServer*)ic;
  is->stop();
  socket = new ClientSocket(is->Host(), is->Port().toInt());
  if (socket->Open()<1){
     slotDisconnected();
     return;
  }
  slotConnected();
}

void DCCClient::slotAccept(ClientSocket* cs)
{
#ifdef EDEBUG
  cout << "DCCClient::slotAccept:"<<endl;
#endif
  stop();
  disconnect(&server,
	     SIGNAL(signAccept(ClientSocket*)),
	     this,
	     SLOT  (slotAccept(ClientSocket*)));
  server.Close();
  socket = cs;
  InetAddress inAddr=socket->getInetAddress();
  host = new IrcServer(inAddr.getHostAddress(), socket->getPeerPort());
  slotConnected();
}

void DCCClient::slotConnected()
{
#ifdef EDEBUG
  cout << "DCCClient::slotConnected:"<<endl;
#endif
  if (type==DCC_OUTGOING)
     disconnect(this,
		SIGNAL(signCusTimeout(IrcCore*)),
		this,
		SLOT  (slotCusTimeout(IrcCore*)));
  sn = new QSocketNotifier(socket->getSocket(), QSocketNotifier::Read, this);
  QObject::connect(sn, SIGNAL(activated(int)), this, SLOT(slotMsgParse(int)));
  connect(socket,
	  SIGNAL(signError()),
	  SIGNAL(signDisconnected()));
  state = 1;
  emit signConnected();
}

void DCCClient::slotDisconnected()
{
#ifdef EDEBUG
  cout << "DCCClient::slotDisconnect:"<<endl;
#endif
  stop();
  if (socket){
     disconnect(socket, SIGNAL(signError()));
     delete socket;
     socket = 0L;
  }
  if (sn){
     delete sn;
     sn = 0L;
  }
  state = 0;
  emit signDisconnected();
}

void DCCClient::slotMsgParse(int s)
{
  if (s<1)
     return;
}

void DCCClient::slotCusTimeout(IrcCore*)
{
#ifdef EDEBUG
  cout << "DCCClient::slotCusTimeout:"<<endl;
#endif
  stop();
  disconnect(this,
	     SIGNAL(signCusTimeout(IrcCore*)),
	     this,
	     SLOT  (slotCusTimeout(IrcCore*)));
  disconnect(&server,
	     SIGNAL(signAccept(ClientSocket*)),
	     this,
	     SLOT  (slotAccept(ClientSocket*)));
  server.Close();
  slotWriteMsg(TYPE_INFO|TYPE_IMG, "Timeout...");
  slotDisconnected();
}




