#ifndef __DCCFILEPAGE_H__
#define __DCCFILEPAGE_H__

#include "kprogress.h"
#include "dccFile.h"
#include "outputPage.h"

class DCCFilePage : public OutputPage
{
  Q_OBJECT
protected:
  DCCFile*    dccClient;
  KProgress*  progress;
  QLabel*     label;
protected:
  void Init();
  void createPopup();
  void createProgress();
  void createToolbar();
  virtual void resizeEvent(QResizeEvent*);
public slots:
  void slotServe();
  void slotConnect();
  void slotConnected();
  void slotDisconnected();
  void slotLiveStatus(IrcCore* ic);

  void slotDCCPopup      (const char*, const QPoint&);
  void slotDCCPopupAction(const char*);
  
  virtual void slotExit(MDIWindow*);
  void slotValue(int, ulong, ulong);
  void slotWriteMsg(int type, const char* txt, bool parse=true);
public:
  DCCFilePage(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~DCCFilePage();
  DCCFile* getClient();
};

#endif 



