#ifndef __DCCVIEW_H__
#define __DCCVIEW_H__

#include <qframe.h>
#include <qcombo.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qstrlist.h>
#include "ktabctl.h"
#include "ircClient.h"
#include "dccChatTab.h"
#include "dccFileTab.h"

class DCCView : public QFrame
{
  Q_OBJECT
public:
  DCCView (IrcClient* client, QWidget* parent=NULL, const char* name=NULL);
  ~DCCView();
public slots:
protected:
   void resizeEvent(QResizeEvent *);
   void closeEvent (QCloseEvent *e);
public:
   KTabCtl*       tabCtl;
   QDict<QWidget> wid;
   QDict<QWidget> tab;
   DCCChatTab*    dccChatTab;
   DCCFileTab*    dccFileTab;
   QWidget*       getTab(const char* Name);
   bool           isActive();
private:
   IrcClient* client;
};

#endif



