#include <iostream.h>
#include <stdlib.h>
#include <qdir.h> 
#include "kprocess.h"
#include "kconfig.h"
#include "ircSleeper.h"
#include "ircApp.h"

QString IrcApp::home       = (const char*)getenv("HOME");
QString IrcApp::keircHome  = (const char*)getenv("HOME")+QString("/.keirc");;
QString IrcApp::entryGroup = "kEirc Option";
KConfig* IrcApp::config    = 0L;

IrcApp::IrcApp(int& argc, char** argv):
  KApplication(argc, argv)
{
  localHost = "localhost";
  if (config==0L)
     config=getConfig();
  config->setGroup(entryGroup);

  // new keirc 0.2
  QDir dir;
  if (!dir.exists(keircHome))
     dir.mkdir(keircHome);
}

IrcApp::~IrcApp()
{
#ifdef EDEBUG
  cout << "Destruktor IrcApp"<<endl;
#endif
}

// PathDefault relativ zu homedir
QString IrcApp::readPathEntry(const char* Entry, const char* PathDefault)
{
  QString path = config->readEntry(Entry);
  if (path.isEmpty()){
     path=home+"/.keirc/"+QString(PathDefault);
     config->writeEntry(Entry, path);
     config->sync();
  }
  return path;
}

QString IrcApp::readEntry(const char* Entry, const char* Default)
{
  return config->readEntry(Entry, Default);
}

int IrcApp::readNumEntry(const char* Entry, int Default)
{
  return config->readNumEntry(Entry, Default);
}

void IrcApp::writeEntry(const char* Entry, const char* Value)
{
  config->writeEntry(Entry, Value);
  config->sync();
}

void IrcApp::writeEntry(const char* Entry, int Value)
{
  config->writeEntry(Entry, Value);
  config->sync();
}

void IrcApp::writeEntry(const char* Entry, const QColor& clr)
{
  config->writeEntry(Entry, clr);
  config->sync();
}

int IrcApp::browseInit()
{
  QString val=readEntry("OnBrowser", "Netscape");
  if (!stricmp(val, "Netscape")){
     int status=remoteNetscape.Init();
     if (!status){
         KProcess proc;
	 proc << "netscape";
         proc.start(KProcess::DontCare, KProcess::All);
	 for (int i=0; i<20 && !status; i++) {
	     IrcSleeper is;
	     is.start(5);
	    status=remoteNetscape.Init();
	 } 
     }
     return status;
  }
  return 0;
}

void IrcApp::browse(const char* cmd)
{
  setOverrideCursor(waitCursor);
  int status = browseInit();

  if (status){
     QString val=readEntry("OnBrowser", "Netscape");
     if (!stricmp(val, "Netscape")){
        remoteNetscape.commands(cmd);
     }
  }
  restoreOverrideCursor();
}

void IrcApp::browse(const char* Cmd, const char* Arg)
{
  setOverrideCursor(waitCursor);
  int status = browseInit();

  if (status){
     QString val=readEntry("OnBrowser", "Netscape");
     if (!stricmp(val, "Netscape")){
        QString cmd=QString(Cmd)+"("+QString(Arg)+")";
	remoteNetscape.commands(cmd);
     }
  }
  restoreOverrideCursor();
}







