#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qtooltip.h> 
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "ircClient.h"
#include "ircBell.h"
#include "ircBell.moc"
#include "ircApp.h"
#include <X11/Xlib.h>

void IrcBell::Init()
{
  intLine.setAutoDelete (false);
  propText.setAutoDelete(true);
}

IrcBell::IrcBell(IrcClient* client, const char* PrefEntry, QWidget *parent, const char *name ) : 
  QGroupBox("Bell",  parent, name )
{
  Init();
  this->client=client;
  prefEntry = PrefEntry;

  QVBoxLayout* vbox = new QVBoxLayout(this, 10);

  QString entry;
  QHBoxLayout* hbox;
  
  QLabel* label;
  KIntegerLine* il;
  vbox->addSpacing(fontMetrics().height());
  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Volume [%]", this);
  hbox->addWidget(label,10);
  propText.append(entry=prefEntry+"Vol");
  intLine.insert(entry, il = new KIntegerLine(this, "line", KEditTypeDec));
  il->setFixedSize(40, il->sizeHint().height());
  hbox->addWidget(il);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Pitch [hz]", this);
  hbox->addWidget(label,10);
  propText.append(entry=prefEntry+"Pitch");
  intLine.insert(entry, il = new KIntegerLine(this, "line", KEditTypeDec));
  il->setFixedSize(40, il->sizeHint().height());
  hbox->addWidget(il);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Duration [seconds]", this);
  hbox->addWidget(label,10);
  propText.append(entry=prefEntry+"Dur");
  intLine.insert(entry, il = new KIntegerLine(this, "line", KEditTypeDec));
  il->setFixedSize(40, il->sizeHint().height());
  hbox->addWidget(il);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  QPushButton* btn;
  btn = new QPushButton(" Test ", this);
  hbox->addWidget(btn, AlignLeft);
  btn->setFixedSize(75, 20);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotTest()));
  hbox->addStretch(10);
  vbox->activate();
  adjustSize();
  setFixedHeight(childrenRect().height()+3*fontMetrics().height());
  readConfig();
  show();
}

IrcBell::~IrcBell()
{
#ifdef EDEBUG
  cout << "Destruktor IrcBell" << endl;
#endif
}

void IrcBell::readConfig()
{
  QString entry;
  QString value;
  
  entry=prefEntry+"Vol";
  value = ircapp->readEntry(entry, "0");
  if (value.toInt()>100)
     value.setNum(100);
  intLine[entry]->setText(value);

  entry=prefEntry+"Pitch";
  value = ircapp->readEntry(entry, "1200");
  if (value.toInt()>2000)
     value.setNum(2000);
  intLine[entry]->setText(value);

  entry=prefEntry+"Dur";
  value = ircapp->readEntry(entry, "50");
  if (value.toInt()>500)
     value.setNum(500);
  intLine[entry]->setText(value);

}

void IrcBell::slotApply()
{
#ifdef EDEBUG
  cout << "IrcBell::slotApply:"<<endl;
#endif
  QString entry;
  QString value;

  value = intLine[prefEntry+"Vol"]->text();
  if (value.toInt()>100){
     value.setNum(100);
     intLine[prefEntry+"Vol"]->setText(value);
  }

  for (entry=propText.first();entry!=NULL;entry=propText.next()){
     value = intLine[entry]->text();
     ircapp->writeEntry(entry, value);
  }
}

void IrcBell::slotTest()
{
#ifdef EDEBUG
  cout << "IrcBell::slotTest:"<<endl;
#endif

  QString value;
  struct XKeyboardState old_state;
  XGetKeyboardControl(kapp->getDisplay(), &old_state);

  // switch to the test state
  struct XKeyboardControl kbd;
  value = intLine[prefEntry+"Vol"]->text();
  if (value.toInt()>100){
     value.setNum(100);
     intLine[prefEntry+"Vol"]->setText(value);
  }
  kbd.bell_percent  = value.toInt();
  value = intLine[prefEntry+"Pitch"]->text();
  kbd.bell_pitch    = value.toInt();
  value = intLine[prefEntry+"Dur"]->text();
  kbd.bell_duration = value.toInt();
  XChangeKeyboardControl(ircapp->getDisplay(),
                         KBBellPercent | KBBellPitch | KBBellDuration,
                         &kbd);
  // ring bell
  value = intLine[prefEntry+"Vol"]->text();
  int vol=(value.toInt()>100)?100:value.toInt();
  XBell(ircapp->getDisplay(), vol);

  // restore old state
  kbd.bell_percent  = old_state.bell_percent;
  kbd.bell_pitch    = old_state.bell_pitch;
  kbd.bell_duration = old_state.bell_duration;
  XChangeKeyboardControl(ircapp->getDisplay(),
                         KBBellPercent | KBBellPitch | KBBellDuration,
                         &kbd);
}


void IrcBell::slotPlay()
{
#ifdef EDEBUG
  cout << "IrcBell::slotPlay:"<<endl;
#endif

  struct XKeyboardState old_state;
  XGetKeyboardControl(ircapp->getDisplay(), &old_state);

  // switch to the test state
  struct XKeyboardControl kbd;
  int vol =ircapp->readNumEntry(prefEntry+"Vol", 0);
  if (vol>100)
     vol=100;
  
  kbd.bell_percent  = vol;
  kbd.bell_pitch    = ircapp->readNumEntry(prefEntry+"Pitch", 1200);
  kbd.bell_duration = ircapp->readNumEntry(prefEntry+"Dur",   50  );
  XChangeKeyboardControl(ircapp->getDisplay(),
                         KBBellPercent | KBBellPitch | KBBellDuration,
                         &kbd);
  // ring bell
  XBell(ircapp->getDisplay(), vol);

  // restore old state
  kbd.bell_percent  = old_state.bell_percent;
  kbd.bell_pitch    = old_state.bell_pitch;
  kbd.bell_duration = old_state.bell_duration;
  XChangeKeyboardControl(ircapp->getDisplay(),
                         KBBellPercent | KBBellPitch | KBBellDuration,
                         &kbd);
}



