#ifndef __IRCCHANNEL_H__
#define __IRCCHANNEL_H__

#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qdict.h>
#include "clientCore.h"
#include "channelUser.h"
#include "channelMode.h"

class IrcClient;

class IrcChannel : public ClientCore
{
  Q_OBJECT
protected:
  ChannelMode mode;
public:
  IrcClient* client;
  QDict<ChannelUser>* cuList;
  QString             topic;
  QString             topicBy;
  ChannelMode&  getMode();
  int                 firstJoin;
  BanList*            banList;
public:
  IrcChannel(const char* Channel, QObject* Parent, const char* Name=0);
  ~IrcChannel();
  virtual QString cmdSubstitution(const char* Txt);
  int setMode (const char* Mode, const char* Param);
  int setTopic(const char* Topic, const char* From);
  int joinChannel(const char* User);
  int partChannel(const char* User);
  int addUser    (const char* Nick, const char* User="", const char* Host="");
  int delUser    (const char* Nick);
  int addUserMode(const char* Nick, const char* Mode);
  int delUserMode(const char* Nick, const char* Mode);
  int changeNick (const char* Nick, const char* NewNick);
  int onKick     (const char* From, const char* Txt);
  int onKill     (const char* From, const char* Txt);
  int onQuit     (const char* From, const char* Txt);
  virtual int onMsg      (const char* From, const char* Txt);
  bool checkFlood(const char* Who);
  void addBan    (const char* ident, ulong second);
  void timeChecker();
signals:
  void signTopic   (const char* Topic, const char* From);
  //void signPartChannel(const char* Channel);
  void signAddUser    (const char* Nick);
  void signDelUser    (const char* Nick);
  void signChangeUserMode (const char* Nick, const char* Mode);
  void signChangeNick     (const char* Nick, const char* NewNick);
public slots:
  void slotInputParse(const char* Txt);
};

#endif


