#ifndef __IRCVIEW_H__
#define __IRCVIEW_H__

#include <qlabel.h>
#include <qpopupmenu.h> 
#include <qtimer.h>
#include "MDI.h"
#include "ircClient.h"
#include "channelPage.h"
#include "privMsgPage.h"
#include "dccChatPage.h"
#include "dccFilePage.h"

#define MAX_WIDTH   150

class WindowButton : public QPushButton
{
  Q_OBJECT
  friend class StatusBar;
protected:
  MDIWindow* mdiWnd;
  QLabel*    label;
  QLabel*    lPixmap;
  QColor     bgColor;
  QColor     fgColor;
  QColor     msgColor;
  QColor     newColor;
  QPopupMenu* puMenu;
  int idClose;
  int idMinimize;
  int idMaximize;
  QTimer     aniTimer;
signals:
  void toggled(MDIWindow*, bool);
protected:
  bool eventFilter ( QObject *, QEvent *e );
  virtual void mousePressEvent(QMouseEvent*);
  virtual void resizeEvent    (QResizeEvent*);
public:
  WindowButton(MDIWindow* w=0L, const char* txt="", const char* pixmap=0L, int flag=0,
	       QWidget* p=0L, const char* name=0L);
  virtual ~WindowButton(){}
  inline void setWindow(MDIWindow* w){
    mdiWnd=w;
  }
  inline MDIWindow* getMDIWindow(){
    return mdiWnd;
  }

public slots:
  void setOff();
  void slotToggled(bool);
  void slotChangeText(MDIWindow*, const char* txt);
  void popupActivated(int);
  void slotMsgColor  ();
  void slotAnimation ();
};

class StatusBar : public QWidget
{
  Q_OBJECT
protected:
  QFrame* frame;
  QList<WindowButton> btnList;
signals:
  void selected(MDIWindow*);
protected:
  virtual void resizeEvent ( QResizeEvent *);
public:
  StatusBar(QWidget *parent = 0L, const char *name = 0L);
  virtual ~StatusBar(){}
public slots:
  void slotToggled(MDIWindow*, bool);
  WindowButton* addButton  (MDIWindow*, const char* pixmap=0L);
  void delButton  (MDIWindow*);
  void setOn      (MDIWindow*);
  void updateRect ();
};


class IrcMDI : public QFrame
{
  Q_OBJECT
protected:
  IrcClient*  client;
  MDIManager* mdi;
  StatusBar*  statusBar;
  QList<ChannelPage> cpList;
  QList<PrivMsgPage> pmpList;
  QList<WindowPage>  wpList;
  QList<DCCChatPage> dcpList;
  QList<DCCFilePage> dfpList;
public:
  IrcMDI(IrcClient* client, QWidget* p=0L, const char* name=0L);
  virtual ~IrcMDI(){}
  MDIManager* getMDI(){
    return mdi;
  }
public slots:
  void slotAddOutputPage(const char* name, int flag, bool detach, const char* pix=0L);
  void slotDelOutputPage(const char*);
  void slotWritePage(const char* name, int Type, const char* Msg, bool Parsen=true);
  void slotAddChannel(const char* Channel, const char* Key, int flag=MDI_ICONIFY);
  void slotDelChannel(IrcChannel*);
  void slotAddPrivMsg(const char* Name, int flag);
  void slotDelPrivMsg(IrcPrivMsg*);
  void slotAddDCCChat(const char* Name, int flag);
  void slotDelDCCChat(DCCChat*);
  void slotAddDCCFile(const char* Name, int flag);
  void slotDelDCCFile(DCCFile*);
};

#endif
