#ifndef __PAGETAB_H__
#define __PAGETAB_H__

#include <qobject.h>
#include <qframe.h>
#include <qlistbox.h>
#include <knewpanner.h>
#include <ktreelist.h>
#include <qdict.h>

class IrcClient;

class PageTab : public QFrame
{
  Q_OBJECT
protected:
  KNewPanner* panner;
  KTreeList*  treeList;
  QWidget*    pageWidget;
  QDict<QWidget>* page;
  IrcClient*      client;
protected:
  void resizeEvent(QResizeEvent*);
  virtual void createTreeListItem();
signals:
  void signCurrentPage(const char*);
public slots:
  void slotSetPage(int idx);
  void slotChangeItemName(const char* Old, const char* New);
  void slotDelPage(const char* Name);
  void slotDetach(bool, const char*);
public:
  PageTab(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~PageTab();
  QWidget* getPage(const char* Name);
  bool     isActive();
};

#endif 
