#include "serverDialog.h"

ServerDialog::ServerDialog(QWidget *parent, const char *name )
     :QDialog( parent, name, TRUE)
{
    int i;
    const char* text[4] =  { "Host   : ",
			     "Port   : ",
			     "Info   : ",
			     "Passwd : "};
    resize        (300, 200);
    setMinimumSize(300, 200);
    setMaximumSize(300, 200);
    QGroupBox* frame = new QGroupBox(this);
    frame->setGeometry(5,5,
		       width()-10,
		       height()-50);
    for (i=0;i<4;i++){
       label[i] = new QLabel(frame);
       label[i]->setText(text[i]);
       label[i]->setAlignment(AlignRight|AlignVCenter);
       label[i]->setGeometry(frame->x(),
			     i ? label[i-1]->y()+label[i-1]->height()+5 : frame->y()+5, 
			     label[i]->width(), 
			     25 );
    
       edit[i]  = new QLineEdit(frame);
       edit[i]->setGeometry( label[i]->x()+label[i]->width()+5, 
			     i ? label[i-1]->y()+label[i-1]->height()+5 : frame->y()+5,
			     frame->width()/2 + 20, 
			     25);
    }
    frame->setGeometry(5,
		       5,
		       width()-10,
		       edit[i-1]->y()+edit[i-1]->height()+10);

    QPushButton* ok, *cancel;
    ok = new QPushButton( "Ok", this );
    ok->setGeometry(width()/2-80,
		    height()-10-25,
		    75,
		    25 );
    connect( ok, SIGNAL(clicked()), this, SLOT(accept()) );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry(width()/2+5,
			height()-10-25,
			75,
			25 );

    connect( cancel, SIGNAL(clicked()), this, SLOT(reject()) );
    for (i=0;i<4;i++)
        connect( edit[i], SIGNAL(returnPressed()),
		 this,    SLOT  (accept()));
    edit[0]->setFocus();
}

ServerDialog::~ServerDialog()
{
 
}

QString ServerDialog::getHost()
{
   QString f;
   QString e = edit[0]->text();
   if (!e.isNull() && !e.isEmpty()){
      f=e.stripWhiteSpace();
      if (!f.isEmpty() && !f.isNull())
	 return f;
   }
   return QString("");
}

QString ServerDialog::getPort()
{
   QString e = edit[1]->text();
   QString f;
   if (!e.isNull() && !e.isEmpty()){
      f=e.stripWhiteSpace();
      if (!f.isNull() && !f.isEmpty()){
	 bool status;
	 f.toInt(&status);
	 if (status==TRUE)
	    return f;
      }
   }
   return ("6667");
}

QString ServerDialog::getInfo()
{
   QString e = edit[2]->text();
   if (!e.isNull() && !e.isEmpty()){
      QString f=e.stripWhiteSpace();
      if (!f.isEmpty() && !f.isNull())
	 return f;
   }
   return QString("");
}

QString ServerDialog::getPasswd()
{
   QString e = edit[3]->text();
   if (!e.isNull() && !e.isEmpty()){
      QString f=e.stripWhiteSpace();
      if (!f.isEmpty() && !f.isNull())
	 return f;
   }
   return QString("");
}

void ServerDialog::setHost(QString text)
{
   edit[0]->setText(text);
}

void ServerDialog::setPort(int port)
{
   QString tmp;
   tmp.sprintf("%d", port);
   edit[1]->setText(tmp);
}

void ServerDialog::setPort(QString text)
{
   edit[1]->setText(text);
}

void ServerDialog::setInfo(QString text)
{
   edit[2]->setText(text);
}

void ServerDialog::setPasswd(QString text)
{
   edit[3]->setText(text);
}
