#ifndef __MEDIADIALOG_H__
#define __MEDIADIALOG_H__

#include <qlayout.h>
#include <qbttngrp.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qdatetm.h>
#include <qtimer.h>
#include <qdict.h>
#include <qfiledlg.h> 
#include <qtimer.h>
#include <qcombo.h> 
#include "ircLine.h"
#include "fileListBox.h"
#include "kprocess.h"

class IrcClient;

class MediaDialog : public QDialog
{
  Q_OBJECT
protected:
  IrcClient*   client;
  FileBox*     fileBox;
  IrcLine*     toLine;
  IrcLine*     titleLine;
  QVBoxLayout* verLayout;
  QHBoxLayout* horLayout;
  KProcess     proc;
  QPushButton* playBtn;
  QStrList     queueList;
  QTimer*      playTimer;
public:
  MediaDialog(IrcClient* Client, bool Modal=TRUE, QWidget *parent=NULL, const char *name=NULL);
  ~MediaDialog();
protected:
  void    readConfig();
  void    createButton();
  void    createFileBox();
protected slots:
  void slotPlay(const char*);
  void slotPlayTimer();
  void slotPlayRemote();
  void slotPlayLocal();
  void slotRefresh();
  void slotStop();
  void slotOk();
  void slotSetup();
  void slotProcExit(KProcess*);
public slots:
  void slotPlayCTCP(const char*);
  virtual void show(const char* to=NULL);
};

#endif




