#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qdir.h>
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "kmsgbox.h"
#include "ircDefine.h"
#include "onWebServerPage.h"
#include "onWebServerPage.moc"
#include "ircApp.h"

MimeTypePage::MimeTypePage(QDict<char>* dict, QWidget *parent, const char *name ) : 
  DictPage(dict, "Mime Types", parent, name)
{
  entry  = "WebServerMimeTypes";
  path   = "Mime.types";
  filter = "*.types";
  FileReader fr(dict, entry, path);
  path = fr.getPath();
  fr.load();
  load();
}

MimeTypePage::~MimeTypePage()
{
#ifdef EDEBUG
  cout << "Destruktor MimeTypePage" << endl;
#endif
}


void OnWebServerPage::Init()
{
  btnGroup.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);
  checkBox.setAutoDelete(false);

  checkText.setAutoDelete(true);
  configText.setAutoDelete(true);
}

OnWebServerPage::OnWebServerPage(WebServer* webServer, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->webServer=webServer;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createCheckBox();
  createConfigBox();
  createPushButton();

  topLayout->activate();
  readConfig();
  show();
}

OnWebServerPage::~OnWebServerPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnWebServerPage" << endl;
#endif
}


void OnWebServerPage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());

  QLabel* label;
  KIntegerLine* il;

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Port", gb);
  hbox->addWidget(label,5);
  configText.append(entry="WebServerPort");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(25);
  hbox->addWidget(il,3);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max Client", gb);
  hbox->addWidget(label,5);
  configText.append(entry="WebServerClientMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(25);
  hbox->addWidget(il,3);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Root Dir", gb);
  hbox->addWidget(label,5);
  configText.append(entry="WebServerRootDir");
  rootDirBox = new FileDirBox(gb);
  hbox->addWidget(rootDirBox, 10);
  rootDirBox->setFixedHeight(25);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("CGI Dir", gb);
  hbox->addWidget(label,5);
  configText.append(entry="WebServerCGIDir");
  cgiDirBox = new FileDirBox(gb);
  hbox->addWidget(cgiDirBox, 10);
  cgiDirBox->setFixedHeight(25);

  vbox->activate();
}

void OnWebServerPage::createCheckBox()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Startup", bg=new QButtonGroup("Startup", this));
  grid->addWidget(bg, 0, 0);

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QCheckBox* cb;
  checkText.append(entry=qstrdup("WebServerAutoStart"));
  checkBox.insert(entry, cb = new QCheckBox("Auto Start", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);

  vbox->addStretch(10);
  vbox->activate();
}


void OnWebServerPage::createPushButton()
{
  QPushButton* btn;
  QVBoxLayout* vbox=new QVBoxLayout(0);
  grid->addLayout(vbox, 1, 0);
  btn = new QPushButton(" Apply ", this);
  vbox->addWidget(btn, 10, AlignLeft);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  btn->setFixedSize(100, 25);
  vbox->addStretch(10);
}

void OnWebServerPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnWebServerPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;
  
  entry = "WebServerPort";
  value = ircapp->readEntry(entry, "6789");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // max webclient
  entry = "WebServerClientMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  for (entry=checkText.first();entry;entry=checkText.next()){
      value = ircapp->readEntry(entry, "No");
      if (value=="Yes")
	 checkBox[entry]->setChecked(1);
      ircapp->writeEntry(entry, value);
  }

  QString dir=ircapp->readEntry("WebServerRootDir", ircapp->keircHome);
  rootDirBox->setPath(dir);
  dir=ircapp->readEntry("WebServerCGIDir", ircapp->keircHome);
  cgiDirBox->setPath(dir);
}

void OnWebServerPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnWebServerPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;

  entry = "WebServerClientMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  entry = "WebServerPort";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  QCheckBox* cb;
  for (entry=checkText.first();entry;entry=checkText.next()){
      cb=checkBox[entry];
      if (!cb)
	 continue;
      if (cb->isChecked())
	 value="Yes";
      else
	 value="No";
      ircapp->writeEntry(entry, value);
  }

  QString dir=rootDirBox->currentText();
  ircapp->writeEntry("WebServerRootDir", dir);
  dir=cgiDirBox->currentText();
  ircapp->writeEntry("WebServerCGIDir", dir);
}




