#!/usr/bin/env python

####################################################################
#                                                                  #
# The installer is (C) Martin P Holland 2000                       #
# I give unlimited permission to copy, distribute and modify it.   #
# No warranty is given or implied for the installer. You use it at #
# your own risk.                                                   #
#                                                                  #
####################################################################


import sys, os, compileall, string, ConfigParser, getopt

def usage():
    print """
Specify

./install.py

to install and

./install.py -e

to uninstall"""
    sys.exit(1)
try:
    optlist,args=getopt.getopt(sys.argv[1:],'e')
except getopt.error,detail:
    usage()
install=1
if len(optlist)==1:
    if optlist[0][0]=="-e": install=0

p=ConfigParser.ConfigParser()
p.read("Config")
if "Options" not in p.sections():
    print "Broken Config file. Please run ./configure.py"
    sys.exit(1)

app=p.get("Options","APP")
menudir=p.get("Options","MENUDIR")
datadir=p.get("Options","KDEDATADIR")+'/'+app+'/'
bindir=p.get("Options","KDEBINDIR")+'/'
docdir=p.get("Options","KDEHTMLDIR")+'/default/'+app+'/'
icondir=p.get("Options","KDEICONDIR")+'/'
lnkdir=p.get("Options","KDELNKDIR")+'/'
lnkdir=lnkdir+menudir+'/'


#insert custom options here
###########################

clidir=p.get("Options","CLIDIR")


###########################

def installdir(d):
    "Install a directory"
    if install:
        print 'Creating directory',d
        if os.system('install -d --owner=root --group=root --mode=755 '+d):
            print 'FAILED'
    else:
        print 'Removing directory',d
        if os.system('rm -rf '+d):
            print 'FAILED'
            
def installcontents(d,e,m='644'):
    "Install content of a directory"
    if install:
        print 'Installing content in',e
        if os.listdir(d)==[]:
            print d,'is empty; nothing to do'
            return
        if os.system('install --owner=root --group=root --mode='+m+' ' +d+'/* '+e):
            print 'FAILED'

def installfile(f,e,m='644'):
    "Install a file"
    if install:
        print 'Installing',e+f
        if os.system('install --owner=root --group=root --mode='+m+' ' +f+' '+e+f):
            print 'FAILED'
    else:
        print 'Removing',e+f
        if os.system("rm -f "+e+f):
            print "FAILED"

if install:
    print 'Installing application called',app
else:
    print 'Uninstalling application called',app

#install icons
if os.path.isdir("icons"):
    os.chdir("icons")
    if os.path.isfile(app+'.xpm'):
        installfile(app+'.xpm',icondir)
    if os.path.isdir("mini"):
        os.chdir("mini")
        if os.path.isfile(app+'.xpm'):
            installfile(app+'.xpm',icondir+"mini/")
        os.chdir("..")
    os.chdir("..")

#install kdelnk template
if install:
    f=open("template.kdelnk","r")
    lines=f.readlines()
    f.close()
    g=open(app+'.kdelnk','w')
    for line in lines:
        line=string.replace(line,"APP",app)
        g.write(line)
    g.close()
    installfile(app+'.kdelnk',lnkdir)
    os.remove(app+'.kdelnk')
else:
    installfile(app+'.kdelnk',lnkdir)

#create app data directory
installdir(datadir)

#install contents of app data directory
if install:
    os.chdir('data')
    for d in os.listdir('.'):
        if not os.path.isdir(d):
            installfile(d,datadir)
        else:
            installdir(datadir+d)
            installcontents(d,datadir+d)
    os.chdir('..')

#compile python files
if install:
    print 'Compiling python'
    compileall.compile_dir(datadir+'python')

#install any c modules
#we don't have an uninstall routine here because there doesn't
#appear to be an uninstall target in the standard Makefile

if install and os.path.isdir("c"):
    print "Installing c modules"
    ans=os.chdir('c')
    if not ans: ans1=os.system('make -f Makefile.pre.in boot')
    if not ans1: ans1=os.system('make')
    if not ans1: ans1=os.system('make install')
    if ans: print "FAILED"
    
    else:
        #tidy up so there are no root owned files
        os.system('make clobber')
        os.remove('Makefile')
    if not ans:
        os.chdir('..')

#create app doc dir
installdir(docdir)

#install doc contents
if install: installcontents('doc',docdir)

#Create redirecting shell script in bindir
if install:
    f=open(app,'w')
    f.write('#!/bin/sh\n')
    f.write('python '+datadir+'python/main.py $*\n')
    f.close()
    installfile(app,bindir,'755')
    os.remove(app)
else:
    installfile(app,bindir)

#add custom install.uninstall options here
##########################################

#Addition to the generic script for the command line app

#Create redirecting shell script in clidir for ftpupdater
cliapp='ftpupdater'
if install:
    f=open(cliapp,'w')
    f.write('#!/bin/sh\n')
    f.write('python '+datadir+'python/'+cliapp+'.py $*\n')
    f.close()
    installfile(cliapp,clidir+'/bin/','755')
    os.remove(cliapp)
else:
    installfile(cliapp,clidir+'/bin/')
#install man page
installfile(cliapp+'.1',clidir+'/man/man1/','644')
    

##########################################
