/* $Id: dlgLimits.cpp,v 1.2 1999/02/19 15:40:30 koss Exp $
   $Log: dlgLimits.cpp,v $
   Revision 1.2  1999/02/19 15:40:30  koss
   disabled unsupported features

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>

#include "dlgLimits.h"

extern QString getStringFromInt( int x );
extern int getIntFromString( QString s );

DlgLimits::DlgLimits(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QVBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
  topLayout->addSpacing( 5 );

  gb_limits = new QGroupBox(this, "gb_limits");
  gb_limits->setTitle(i18n("Limits Options"));
  topLayout->addWidget( gb_limits, 5 );

  QGridLayout *gridLayout = new QGridLayout( gb_limits, 9, 6, 5 );

  gridLayout->addRowSpacing(0,5);
  gridLayout->addRowSpacing(2,5);
  gridLayout->addRowSpacing(5,5);
  gridLayout->addRowSpacing(8,5);

  gridLayout->addColSpacing(0,5);
  gridLayout->addColSpacing(5,5);

  gridLayout->setRowStretch(0,5);
  gridLayout->setRowStretch(1,5);
  gridLayout->setRowStretch(2,2);
  gridLayout->setRowStretch(3,10);
  gridLayout->setRowStretch(4,5);
  gridLayout->setRowStretch(5,2);
  gridLayout->setRowStretch(6,10);
  gridLayout->setRowStretch(7,5);
  gridLayout->setRowStretch(8,5);
    
  gridLayout->setColStretch(0,2);
  gridLayout->setColStretch(1,5);
  gridLayout->setColStretch(2,5);
  gridLayout->setColStretch(3,5);
  gridLayout->setColStretch(4,5);
  gridLayout->setColStretch(5,2);

  // opened connection
  lb_maxnum = new QLabel(i18n("Maximum number of opened connections :"), gb_limits);
  gridLayout->addMultiCellWidget( lb_maxnum, 1, 1, 1, 3 );

  le_maxnum = new KIntegerLine(gb_limits);
  le_maxnum->setFixedHeight( le_maxnum->sizeHint().height() );
  gridLayout->addWidget( le_maxnum, 1, 4 );

  // minimum bandwidth
  lb_minband = new QLabel(i18n("Start transfer only if network bandwidth is more than :"), gb_limits);
  lb_minband->setFixedHeight( lb_minband->sizeHint().height() );
  gridLayout->addMultiCellWidget( lb_minband, 3, 3, 1, 4 );

  le_minband = new KIntegerLine(gb_limits);
  le_minband->setFixedHeight( le_minband->sizeHint().height() );
  gridLayout->addMultiCellWidget( le_minband, 4, 4, 2, 3 );

  lb_bytes = new QLabel(i18n("b / sec"), gb_limits );
  gridLayout->addWidget( lb_bytes, 4, 4 );

  // maximum bandwidth
  lb_maxband = new QLabel(i18n("Keep maximum bandwidth taken by transfer at :"), gb_limits);
  lb_maxband->setFixedHeight( lb_maxband->sizeHint().height() );
  gridLayout->addMultiCellWidget( lb_maxband, 6, 6, 1, 4 );

  le_maxband = new KIntegerLine(gb_limits);
  le_maxband->setFixedHeight( le_maxband->sizeHint().height() );
  gridLayout->addMultiCellWidget( le_maxband, 7, 7, 2, 3 );

  lb_bytes2 = new QLabel(i18n("b / sec"), gb_limits );
  gridLayout->addWidget( lb_bytes2, 7, 4 );

  //
  gridLayout->activate();

  topLayout->addStretch( 15 );
  topLayout->activate();

  // !!! these are not supported yet, so disable them
  le_maxband->setEnabled( false );
  le_minband->setEnabled( false );
}


DlgLimits::~DlgLimits()
{
}


void DlgLimits::setData(QStrList *strList)
{
  le_maxnum->setValue( getIntFromString( strList->first() ) );
  le_minband->setValue( getIntFromString( strList->next() ) );
  le_maxband->setValue( getIntFromString( strList->next() ) );
}

static QStrList strList(true);

QStrList DlgLimits::getData() const
{
  strList.clear();
  
  strList.append( getStringFromInt( le_maxnum->value() ) );
  strList.append( getStringFromInt( le_minband->value() ) );
  strList.append( getStringFromInt( le_maxband->value() ) );

  return strList;
}

