%{

#include "k2config.tab.h"
#include <string.h>
#include <stdlib.h>

char* k2configPutSymbol( char *_name );
char* putString( char *_name );
int yywrap();

%}

DIGIT    [0-9]

%%

"bool" { return TBOOLEAN; }
"long" { return TLONG; }
"float" { return TFLOAT; }
"string" { return TSTRING; }
"file" { return TFILE; }
"true" { return TAG_TRUE; }
"false" { return TAG_FALSE; }

"@"|"<"|">"|","|"["|"]"|"{"|"}"|"="|";"|":"  { k2configlval.name = 0L; return (int)(*yytext); }
"'"[^']*"'" { k2configlval.name = putString( yytext ); return STRING; }
[a-zA-Z_][a-zA-Z0-9]* { k2configlval.name = k2configPutSymbol( yytext ); return STRING; }

{DIGIT}*"."{DIGIT}+ { k2configlval.valf = atof( yytext ); return FLOAT; }
"-"{DIGIT}+  { k2configlval.vali = atoi( yytext ); return NUM; }
{DIGIT}+  { k2configlval.vali = atoi( yytext ); return NUM; }

[ \t\n]+          /* eat up whitespace */

. { printf( "Unrecognized character: %s\n", yytext ); }

%%

char* k2configPutSymbol( char *_name )
{
  char *p = (char*)malloc( strlen( _name ) + 1 );
  strcpy( p, _name );
  return p;
}

char* putString( char *_str )
{
  int l = strlen( _str );
  char *p = (char*)malloc( l );
  char *s = _str + 1;
  char *d = p;
  while ( s != _str + l - 1 )
  {
     if ( *s != '\\' )
        *d++ = *s++;
     else
     {
        s++;
        if ( *s == '\\' )
          *d++ = '\\';
        else if ( *s == 'n' )
          *d++ = '\n';
        else if ( *s == 'r' )
          *d++ = '\r';
        else if ( *s == 't' )
          *d++ = '\t';
        s++;
     }
  }
  *d = 0;
  return p;
}

void k2config_initFlex( const char *_code )
{
  k2config_switch_to_buffer( k2config_scan_string( _code ) );
}

int k2configwrap()
{
  k2config_delete_buffer( YY_CURRENT_BUFFER );
  return 1;
}
