// $Id: detailswidget.cpp,v 1.3 1998/12/08 16:10:04 denis Exp $
// $Log: detailswidget.cpp,v $
// Revision 1.3  1998/12/08 16:10:04  denis
// Cleaned up a little before releasing
//

#include "detailswidget.h"

#include "detailswidget.moc"

DetailsWidget::DetailsWidget(QWidget *parent) : QWidget(parent)
{
  detbox = new QGroupBox("Search Users By Parameters",this);
  nickline = new QLineEdit(this);
  nicklabel = new QLabel(nickline,"Nick Name:",this);
  firstline = new QLineEdit(this);
  firstlabel = new QLabel(firstline,"First Name:",this);
  lastline = new QLineEdit(this);
  lastlabel = new QLabel(lastline,"Last Name:",this);
}

DetailsWidget::~DetailsWidget()
{
  if(nicklabel)
    delete nicklabel;
  if(nickline);
    delete nickline;
  if(firstlabel)
    delete firstlabel;
  if(firstline);
    delete firstline;
  if(lastlabel)
    delete lastlabel;
  if(lastline);
    delete lastline;
  if(detbox)
    delete detbox;
}

void DetailsWidget::resizeEvent(QResizeEvent *re)
{
  QWidget::resizeEvent(re);
  detbox->setGeometry(6,6,width()-13,height()-13);
  int h = QMAX(QMAX(nickline->sizeHint().height(),firstline->sizeHint().height()),lastline->sizeHint().height());
  int wlbl = QMAX(QMAX(nicklabel->sizeHint().width(),firstlabel->sizeHint().width()),lastlabel->sizeHint().width());
  nicklabel->resize(wlbl,h);
  firstlabel->resize(wlbl,h);
  lastlabel->resize(wlbl,h);
  nickline->resize(width()-wlbl-40,h);
  firstline->resize(width()-wlbl-40,h);
  lastline->resize(width()-wlbl-40,h);
  int mh = height()/4;
  nicklabel->move(15,mh-h/2);
  nickline->move(wlbl+23,mh-h/2);
  firstlabel->move(15,mh*2-h/2);
  firstline->move(wlbl+23,mh*2-h/2);
  lastlabel->move(15,mh*3-h/2);
  lastline->move(wlbl+23,mh*3-h/2);
}

const char *DetailsWidget::nick()
{
  return nickline->text();
}

const char *DetailsWidget::first()
{
  return firstline->text();
}

const char *DetailsWidget::last()
{
  return lastline->text();
}

void DetailsWidget::clear()
{
  nickline->setText("");
	firstline->setText("");
	lastline->setText("");
}
