// $Id: infoabout.cpp,v 1.4 1998/12/08 16:17:09 denis Exp $
// $Log: infoabout.cpp,v $
// Revision 1.4  1998/12/08 16:17:09  denis
// Cleaned up a little before releasing
//

#include "infoabout.h"

#include "infoabout.moc"

AboutWidget::AboutWidget(QWidget *parent) : QWidget(parent)
{
  aboutbox = new QMultiLineEdit(this);
  aboutbox->setFocusPolicy(QWidget::NoFocus);
  QPalette pal = aboutbox->palette();
  QColorGroup colgrp = pal.disabled();
  pal.setDisabled(QColorGroup(colgrp.foreground(),colgrp.background(),colgrp.light(),colgrp.dark(),colgrp.mid(),colgrp.foreground(),colgrp.background()));
  aboutbox->setPalette(pal);
}

AboutWidget::~AboutWidget()
{
  if(aboutbox)
    delete aboutbox;
}

void AboutWidget::resizeEvent(QResizeEvent *re)
{
  QWidget::resizeEvent(re);
  aboutbox->setGeometry(6,6,width()-12,height()-12);
}

void AboutWidget::setInfo(const char *pabout)
{
  aboutbox->setText(pabout);
}
