#ifndef _INFOWINDOW_
#define _INFOWINDOW_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktabctl.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qlabel.h>
#include "infomain.h"
#include "infoaddr.h"
#include "infomore.h"
#include "infoabout.h"
#include "infonotes.h"
#include "useritem.h"

class InfoWindow : public QDialog {
  Q_OBJECT
public:
  InfoWindow(int plocal = TRUE);
  ~InfoWindow();
  void setMain(unsigned long, unsigned long, const char*, const char*, const char*, const char*);
  void setAddr(const char*, const char*, const char*, unsigned short, char, const char*);
  void setMore(const char*, unsigned int, const char*, const char*);
  void setAbout(const char*);
  void setNotes(const char*);
  void setInfo(ContactItem);
  unsigned long UIN();
  void updateInfo(const char*, const char*, const char*, const char*, char);
  void updateExtInfo(const char*, unsigned short, char, const char*, unsigned short, char, const char*, const char*, const char*);
  void stopCommand();
public slots:
signals:
protected:
  ContactItem info;
  KTabCtl *tabctl;
  MainWidget *mainwidget;
  AddrWidget *addrwidget;
  MoreWidget *morewidget;
  AboutWidget *aboutwidget;
  NotesWidget *noteswidget;
  QPushButton *donebtn, *updatebtn;
  QLabel *updateanim;
  int local;
  char upd_count;
  void resizeEvent(QResizeEvent *);
  void closeEvent(QCloseEvent *);
protected slots:
  void doneCommand();
  void updateCommand();
private:
private slots:
};
#endif /* _INFOWINDOW_ */
