#ifndef _PREFERENCES_
#define _PREFERENCES_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtabdlg.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include "prefuser.h"
#include "prefserver.h"
#include "preflog.h"
#include "prefother.h"
#include "prefproxy.h"
#include "prefsound.h"

class Preferences : public QTabDialog {
  Q_OBJECT
public:
  Preferences();
  ~Preferences();
  void setUser(unsigned long, const char *, const char *);
  void setServer(const char *, int);
  void setProxy(int, const char*, unsigned short, int, const char*, const char*);
  void setLogging(int, const char*);
  void setSound(int, int, int);
  void setOther(int, int, int, int, int);
public slots:
signals:
protected:
  UserWidget *userwidget;
  ServerWidget *serverwidget;
  ProxyWidget *proxywidget;
  LoggingWidget *loggingwidget;
  SoundWidget *soundwidget;
  OtherWidget *otherwidget;
protected slots:
  void savePreferences();
private:
private slots:
};
#endif /* _PREFERENCES_ */
