// $Id: preflog.cpp,v 1.3 1998/12/08 16:25:51 denis Exp $
// $Log: preflog.cpp,v $
// Revision 1.3  1998/12/08 16:25:51  denis
// Cleaned up a little before releasing
//

#include "preflog.h"

#include "preflog.moc"

LoggingWidget::LoggingWidget(QWidget *parent) : QWidget(parent)
{
  mainlabel = new QLabel("Enter Logging Settings:",this);
  logbox = new QGroupBox("Logging", this);
  levelbox = new QComboBox(this);
  levelbox->insertItem("Logging off");
  levelbox->insertItem("Fatal messages");
  levelbox->insertItem("Error messages");
  levelbox->insertItem("Warning messages");
  levelbox->insertItem("Other messages");
  levellabel = new QLabel(levelbox, "Level:", this);
  logline = new QLineEdit(this);
  loglabel = new QLabel(logline, "File:", this);
}

LoggingWidget::~LoggingWidget()
{
  if(mainlabel)
    delete mainlabel;
  if(levelbox)
    delete levelbox;
  if(levellabel)
    delete levellabel;
  if(logbox)
    delete logbox;
  if(logline)
    delete logline;
  if(loglabel)
    delete loglabel;
}

void LoggingWidget::resizeEvent(QResizeEvent *re)
{
  QSize mainlblsize, levelboxsize, levellblsize, loglblsize, loglinesize;
  QWidget::resizeEvent(re);
  mainlblsize = mainlabel->sizeHint();
  mainlabel->setGeometry(10,10,mainlblsize.width(),mainlblsize.height());
  logbox->setGeometry(7, 30, width()-13,height()-37);

  levellblsize = levellabel->sizeHint();
  levelboxsize = levelbox->sizeHint();
  loglblsize = loglabel->sizeHint();
  loglinesize = logline->sizeHint();
  int h = QMAX(QMAX(levellblsize.height(),levelboxsize.height()),
	       QMAX(loglblsize.height(),loglinesize.height()));
  int w = QMAX(levellblsize.width(),loglblsize.width());
  levellabel->resize(w, h);
  levelbox->resize(width()-w-40,h);
  loglabel->resize(w, h);
  logline->resize(width()-w-40,h);
  int mh = (logbox->height()-20)/2;
  levellabel->move(15,logbox->y()+mh/2-h/2+15);
  levelbox->move(w+23,logbox->y()+mh/2-h/2+15);
  loglabel->move(15,logbox->y()+mh+mh/2-h/2+15);
  logline->move(w+23,logbox->y()+mh+mh/2-h/2+15);
}

void LoggingWidget::setInfo(int lvl, const char *logname)
{
  levelbox->setCurrentItem(lvl);
  logline->setText(logname);
}

int LoggingWidget::level()
{
  return levelbox->currentItem();
}

const char *LoggingWidget::logfile()
{
  return logline->text();
}
