// $Id: uinwidget.cpp,v 1.3 1998/12/08 16:31:23 denis Exp $
// $Log: uinwidget.cpp,v $
// Revision 1.3  1998/12/08 16:31:23  denis
// Cleaned up a little before releasing
//

#include "uinwidget.h"

#include "uinwidget.moc"

UINWidget::UINWidget(QWidget *parent) : QWidget(parent)
{
  label1 = new QLabel("Enter the user's valid ICQ number:",this);
  uinbox = new QGroupBox("Search Users By ICQ #", this);
  uinline = new KIntegerLine(this);
  label2 = new QLabel(uinline, "ICQ#:", this);
}

UINWidget::~UINWidget()
{
  if(label1)
    delete label1;
  if(label2)
    delete label2;
  if(uinline)
    delete uinline;
  if(uinbox)
    delete uinbox;
}

void UINWidget::resizeEvent(QResizeEvent *re)
{
  QSize label1size, label2size, uinlinesize;
  QWidget::resizeEvent(re);
  label1size = label1->sizeHint();
  label1->setGeometry(10,10,label1size.width(),label1size.height());
  uinbox->setGeometry(6,30,width()-13,height()-37);
  label2size = label2->sizeHint();
  uinlinesize = uinline->sizeHint();
  int h = QMAX(label2size.height(),uinlinesize.height());
  label2->setGeometry(15,30+(uinbox->height()-h)/2,label2size.width(),h);
  uinline->setGeometry(label2->width()+20,30+(uinbox->height()-h)/2,uinbox->width()-label2->width()-24,h);
}

void UINWidget::clear()
{
  uinline->setText("");
}

unsigned long UINWidget::uin()
{
  return uinline->value();
}

int UINWidget::isEmpty()
{
  return strlen(uinline->text())==0;
}
