#include "kldap.h"

AddPage::AddPage(QWidget* parent, Kldapw* kldapw) : KldapPage(parent, kldapw)
{
  parentIndex = kldapw->currentItem();

  if(strcmp(dn, "") == 0)
    {
      QMessageBox::warning(this, "kldap", "No Item selected.\n", "OK", 0);
      return;
    }
	
  QGridLayout* layout = new QGridLayout(this, 10, 2, 5);
  QLabel* lblDN = new QLabel(dn, this);
  QLabel* lblFirstDNElement = new QLabel("First DN Element:", this);
  QLabel* lblObjectClass = new QLabel("Object Class:", this);
  txtFirstDNElement = new QLineEdit(this);

  cmbObjectClass = new QComboBox(true, this);


  cmbObjectClass->insertItem("person");
  cmbObjectClass->insertItem("organization");
  cmbObjectClass->insertItem("country");
  cmbObjectClass->insertItem("organizationalUnit");
  cmbObjectClass->insertItem("organizationalRole");

  QPushButton* btnAdd = new QPushButton("Add", this);
  
  /*lblDN->setMaximumSize(lblDN->sizeHint());
  lblFirstDNElement->setMaximumSize(lblFirstDNElement->sizeHint());
  lblObjectClass->setMaximumSize(lblObjectClass->sizeHint());
  txtFirstDNElement->setMaximumSize(txtFirstDNElement->sizeHint());
  cmbObjectClass->setMaximumSize(cmbObjectClass->sizeHint());
  btnAdd->setMaximumSize(btnAdd->sizeHint());*/
  
  layout->addMultiCellWidget(lblDN, 0, 0, 0, 1);
  layout->addWidget(lblFirstDNElement, 1, 0);
  layout->addWidget(txtFirstDNElement, 1, 1);
  layout->addWidget(lblObjectClass, 2, 0);
  layout->addWidget(cmbObjectClass, 2, 1);
  layout->addWidget(btnAdd, 3, 1);

  /*QString filename = kapp->localconfigdir();
  filename = filename.append("/kldaprc_objects");
  MyConfig myConfig(filename, '\t', 0);*/

  fillList();

  QObject::connect(btnAdd, SIGNAL(clicked()), this, SLOT(add()));

  show();
}

void AddPage::fillList()
{
  QString filename = kapp->localconfigdir();
  filename = filename.append("/kldaprc_objects");
  //MyConfig myConfig(filename);

  

  /*
  QFile file(filename);
  QString s;
  
  if(file.open(IO_ReadOnly))
    {
      QTextStream t(&file);
      while(! t.eof())
	{
	  cout << "Mache was\n";
	  s = t.readLine();
	  QString temp = s.stripWhiteSpace();
	  int sIndex = 0;
	  int sPos;
	  QString result;
	  
	  if(strcmp(temp.left(1), "#") != 0) // Kein # am Anfang
	    {
	      sPos = s.find("\t", sIndex);
	      result = s.mid(sIndex, (sPos - sIndex));
	      
	      if(strcmp(result, "") != 0 && result != NULL)
		{
		  cmbObjectClass->insertItem(result);
		}
	      sIndex = sPos + 1;
	    }
	}
    }
    file.close();*/
}

void AddPage::add()
{
  LDAP* ldap = kldapw->getLDAP();
  LDAPMod ldapmod;
  LDAPMod* ldapmods[10]; // = { &ldapmod };
  LDAPItem* newItem;
  QPixmap pix;
  int error = 0;
  char* values[2];
  values[0] = (char*)cmbObjectClass->currentText();
  values[1] = NULL;

  if(strcmp(values[0], "")==0)
    {
      QMessageBox::warning(this, "kldap", "Please enter an object class", "OK", 0);
      return;
    }
  
  const char* tmp;
  const char* newDN;
  tmp = ((new QString(txtFirstDNElement->text()))->append(", "));
  newDN = ((new QString(tmp)))->append(dn);

  ldapmod.mod_op = LDAP_MOD_ADD;
  ldapmod.mod_type = "objectclass";
  ldapmod.mod_values = values;

  ldapmods[0] = &ldapmod;
  ldapmods[1] = NULL;

  error = ldap_add_s(ldap, (char*)newDN, ldapmods);

  if(error == LDAP_SUCCESS)
     {
       newItem = new LDAPItem((char*)newDN, &(pix = kldapw->getPixmap(values[0])), (char*)newDN);

       kldapw->addChildItem(newItem, parentIndex);
	 /*kldapw->expandOrCollapseItem(kldapw->currentItem());
	   kldapw->expandOrCollapseItem(kldapw->currentItem());*/
     }
  else
    {
      QMessageBox::warning(this, "kldap", ldap_err2string(error), "OK", 0);
    }
}

