/* ------------------------------------------------------------- 

    kngdialog.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: kngdialog.cpp,v 1.2 1999/04/21 21:17:32 ctuztas Exp $

   ------------------------------------------------------------- */


#include "kngdialog.h"

KNGDialog::KNGDialog( QWidget *parent = 0, const char *caption = 0, 
		      const char *text = 0)
  :QDialog( parent, 0, true, WStyle_Tool)
{

  QVBoxLayout *vl  = new QVBoxLayout(this);
  QHBoxLayout *hl1 = new QHBoxLayout();
  QHBoxLayout *hl2 = new QHBoxLayout();
  QHBoxLayout *hl3 = new QHBoxLayout();

  vl->addSpacing(15);
  vl->addLayout(hl1, 5);
  vl->addSpacing(15);
  vl->addLayout(hl2, 5);
  vl->addSpacing(15);
  vl->addLayout(hl3, 5);
  vl->addSpacing(15);

  label = new QLabel( this);
  label->setText( text );
  hl1->addSpacing(20);
  hl1->addWidget( label );
  hl1->addSpacing(20);

  edit = new QLineEdit( this );
  hl2->addWidget( edit );

  ok = new QPushButton( "Ok", this );  
  cancel = new QPushButton( "Cancel", this );
  
  hl3->addSpacing( 20 );
  hl3->addWidget( ok );
  hl3->addSpacing(20);
  hl3->addWidget( cancel );
  hl3->addSpacing( 20 );

  vl->activate();

  connect( ok, SIGNAL(clicked()), SLOT(accept()) );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
  connect( edit, SIGNAL( returnPressed() ), SLOT( accept() ) );
  ok->setFocus();
  resize( 220, 140);
}

void KNGDialog::setButtonText( const char *text)
{
  ok->setText(text);
}

const char * KNGDialog::getEntry()
{
  return edit->text();
}

void KNGDialog::setEntry(const char *text )
{
  edit->setText( text );
}
