/*

        KXicq WindowMaker Dock.app
        1998/1999 Herwin Jan Steehouwer (steehouwer@kde.org)

	Code based on wmppp/wmifs

	[Orig WMMON comments]

	This code was mainly put together by looking at the
	following programs:

	asclock
		A neat piece of equip, used to display the date
		and time on the screen.
		Comes with every AfterStep installation.

		Source used:
			How do I create a not so solid window?
			How do I open a window?
			How do I use pixmaps?
	
	------------------------------------------------------------

	Author: Martijn Pieterse (pieterse@xs4all.nl)

	This program is distributed under the GPL license.
	(as were asclock and pppstats)
*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>

#include <sys/wait.h>
#include <sys/param.h>
#include <sys/types.h>

#include "kxicq-master.xpm"
#include "kxicq-mask.xbm"
#include "kxicq.h"

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "wmgeneral.h"
#include "misc.h"
#include "wmkxicq.h"

extern DockView *dockView;


int		i;
XEvent		Event;
int		but_stat = -1;

char		temp[128];
char		*p;
int wm_init=0;

void wmkxicq_init(int argc, char **argv)
{
    openXwindow(argc,argv, kxicq_master_xpm, (char *)kxicq_mask_bits, 128, 64);

	copyXPMArea(0, 0, 128, 64, 0, 98);
        copyXPMArea(0, 0, 64, 64, 0, 0);
    	setMaskXY(0, 0);

	/* add mouse region */
	AddMouseRegion(0, 5, 48, 58, 60);
        AddMouseRegion(1, 5, 5, 58, 46);

        wm_init=1;
        DrawKxicq();
        DrawStatus("offline");
        DrawMessage("");
        DrawIcon(0);
        
}

void wmkxicq_loop(void)
{
    wm_init=1;
    Display *display=get_display();;
		waitpid(0, NULL, WNOHANG);

                while (XPending(display))
                {
			XNextEvent(display, &Event);
                        switch (Event.type)
                        {
			case Expose:
				RedrawWindow();
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
				break;
                        case ButtonPress:
                            dockView->menu->hide();
                            but_stat = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
                            int x,y;
                            if (but_stat>=0)
                            {
                                switch (Event.xbutton.button) {
                                case 1:
                                    dockView->doDockPress();
                                                    
							break;
						case 2:
							break;
                                case 3:
                                    getPos(&x,&y);
                                    
                                    dockView->showMenu(x+Event.xbutton.x, y+Event.xbutton.y);
                                                    
							break;
                                }
                            }
			    break;
                        case ButtonRelease:
                            case 3:
                                //ckView->menu->hide();
                                break;
                            /*
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
                                if (but_stat == i && but_stat >= 0)
                                {
                                    switch (but_stat)
                                    {
					case 0:
						copyXPMArea(0, 98, 64, 64, 0, 0);
						setMaskXY(0, 0);

						RedrawWindow();
						break;
						
				    }
				} */
			break;
		}
	}
}

void DrawKxicq()
{
    if (wm_init==1)
    {
    char temp[25];
    char *p=temp;

    int j,k=28;

    sprintf(temp,"KXICQ");

		for (j=0; j<5; j++) {
			copyXPMArea((*p-'A')*6 , 74, 6, 9, k, 49);
			k += 6;
			p++;
                }
                RedrawWindow();
    }
}
void DrawStatus(char *st)
{
    if (wm_init==1)
    {
    char temp[25];
    char *p=temp;

    int j,k=4;

    sprintf(temp,"%s---------",st); // - = empty space !
    int len=strlen(temp);
    if (len>9) len=9;

    for (j=0; j<len; j++)
    {
        if (*p=='-')
        {
            copyXPMArea(4 , 74+30, 6, 7, k, 6);
            k += 6;
            p++;
            
        }
        else
        {
			copyXPMArea((toupper(*p)-'A')*6 , 74, 6, 9, k, 5);
			k += 6;
			p++;
        }
        RedrawWindow();
    }
    }
    
}
void DrawMessage(char *st)
{
    if (wm_init==1)
    {
    char temp[25];
    char *p=temp;

    int j,k=4;

    sprintf(temp,"%s---------",st);
    int len=strlen(temp);
    if (len>9) len=9;

    
    for (j=0; j<len; j++) {
        if (*p=='-')
        {
            copyXPMArea(4 , 74+30, 6, 7, k, 36);
            k += 6;
            p++;
            
        }
        else
        {

			copyXPMArea((toupper(*p)-'A')*6 , 74, 6, 9, k, 35);
			k += 6;
			p++;
        }
    }
                RedrawWindow();
    }
}
int IconStatus;

int getIconStatus()
{
    return IconStatus;
}

void DrawIcon(int s)
{
    if (s<0) s=0;
    if (s>2) s=2;
    IconStatus=s;
    if (wm_init==1)
    {
    
    switch(s)
    {
    case 0:
        copyXPMArea(93+18, 65, 7, 7, 5, 50);
        break;
    case 2:
        copyXPMArea(93+9, 65, 7, 7, 5, 50);
        break;
    case 1:
        copyXPMArea(93, 65, 7, 7, 5, 50);
        break;
    }
    RedrawWindow();
    }
}
        

