/***************************************************************************
 connmgr.cpp  -  description                              
 -------------------                                         
 begin                : Wed Jun 9 1999                                           
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "connmgr.h"

#include <pth.h>
#include <qapp.h>
#include <qstring.h>
#include <qheader.h>
#include "connmgrwidget.h"
#include "serversroot.h"
#include "resource.h"

ConnMgr::ConnMgr()
{
    widget=0;
    //    clients.setAutoDelete(false);
}
ConnMgr::~ConnMgr()
{
}



KMTNntpClient *ConnMgr::getConn(const char *profile,const char *group)
{
    //    debug ("entering getConn");

    //First try to match profile *and* group if needed and possible
    QListIterator <KMTNntpClient> it(clients);
    if (group)
    {
        for ( ; it.current(); ++it )
        {
            if (!(strcmp(it.current()->ProfileName(),profile)))
            {
                if (it.current()->busy==0 && it.current()->taken==0)
                {
                    if (!(strcmp(it.current()->GroupName(),group)))
                    {
                        it.current()->taken=1;
                        return it.current();
                    }
                }
            }
        }
    }
    //Then just match profile
    for (it.toFirst() ; it.current(); ++it )
    {
        if (!(strcmp(it.current()->ProfileName(),profile)))
        {
            if (it.current()->busy==0 && it.current()->taken==0)
            {
                it.current()->taken=1;
                return it.current();
            }
        }
    }
    //Then just create one and be done with it
    KMTNntpClient *conn=new KMTNntpClient();
    conn->taken=1;
    clients.append(conn);

    bool success=conn->Connect(profile);
    if (success)
    {
        debug ("(new con) now there are %d conn",clients.count());
        return conn;
    }
    else
    {
        clients.removeRef(conn);
        debug ("connection failed");
        return 0;
    }
}

void ConnMgr::killConn(KMTNntpClient *conn)
{
    debug ("entering killConn");
    conn->Stop();
    conn->Close();
    clients.removeRef(conn);
    debug ("(killed con) now there are %d conn",clients.count());
}

void ConnMgr::releaseConn(KMTNntpClient *conn)
{
    //    debug ("entering releaseConn");
    conn->taken=0;
    //    debug ("Leaving releaseConn");
}





























