/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "watchablething.h"
#include "resource.h"
#include "connmgr.h"
#include "connmgrwidget.h"

#include <qlist.h>
#include <qapp.h>
#include <pth.h>

QList <WatchableThing> thingsToWatch;

WatchableThing::WatchableThing()
{
    curstat=0;
    thingsToWatch.append(this);
}
WatchableThing::~WatchableThing()
{
    thingsToWatch.removeRef(this);
}
void WatchableThing::setStatus(const char *str)
{
    __status[curstat]=str;
    curstat++;
}
void WatchableThing::clearStatus()
{
    if (curstat)
        curstat--;
    __status[curstat]="";
}
const char *WatchableThing::status()
{
    static QString data;
    data="";
    for (int i=0;i<curstat;i++)
    {
        data+=" "+__status[i];
    }
    return data.data();
}

void *thr_UpdateStatuses (void *arg)
{
    int c1,c2,i;
    QListIterator <WatchableThing> it(thingsToWatch);
    while (1)
    {
        c1=thingsToWatch.count();
        c2=connmgr->widget->count();
        i=0;
        while (c1>c2)
        {
            connmgr->widget->insertItem("");
            c2=connmgr->widget->count();
        }
        while (c2>c1)
        {
            connmgr->widget->removeItem(0);
            c1=thingsToWatch.count();
        }
        it.toFirst();
        connmgr->widget->adjust();
        for (;it.current();++it,i++)
        {
            connmgr->widget->changeItem(it.current()->status(),i);
        }
        qApp->processEvents();
        //		pth_usleep(1000000);
        pth_sleep(1);
    }
    return NULL;
}


