// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef NEWENTRYDIALOG_H
#define NEWENTRYDIALOG_H

#include <qstringlist.h>

#include <kdialogbase.h>

class QString;
class QListBox;
class KBiblioShell;

class NewEntryDialog : public KDialogBase
{
    Q_OBJECT
public:
    NewEntryDialog( KBiblioShell *shell, QWidget *parent, const char *name=0 );
    ~NewEntryDialog();

    QString chosenType() const;

protected slots:
    virtual void slotOk();



private:
    QListBox *mListBox;
    QStringList mEntryTypes;

    QString mSelected;
};






#endif










