// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PREFDIALOG_H
#define PREFDIALOG_H

#include <qstringlist.h>
#include <qbuttongroup.h>
#include <kdialogbase.h>

class KBiblioShell;


class EditableChooser : public QButtonGroup
{ 
    Q_OBJECT
public:
    EditableChooser( KBiblioShell *shell, QWidget *parent, const char *name = 0);
    ~EditableChooser();


    void saveChoices();
    
private:
    QStringList mFieldNames;
    KBiblioShell *mShell;
};


class ViewableChooser : public QButtonGroup
{ 
    Q_OBJECT
public:
    ViewableChooser( KBiblioShell *shell, QWidget *parent, const char *name = 0);
    ~ViewableChooser();  
    
};


class PreferencesDialog : public KDialogBase
{
    Q_OBJECT
public:
    PreferencesDialog(	KBiblioShell *shell, QWidget *parent, const char *name=0 );
    ~PreferencesDialog();
    
    
protected slots:
    virtual void slotOk();
    virtual void slotApply();


private:
    EditableChooser *mEditableTab;
    ViewableChooser *mViewableTab;
};






#endif










