/*
 * $Id: ExportCustomDialog.h,v 1.2 1998/03/15 07:11:11 kalle Exp $
 */

#ifndef _EXPORTCUSTOMDIALOG_H
#define _EXPORTCUSTOMDIALOG_H

#include <qdialog.h>
#include <qvalidator.h>

class QLineEdit;
class QRadioButton;

class LyXView;

struct ExportCustomDialogData
{
  enum FileType { LyX, LaTeX, DVI, PostScript, ASCII };
  FileType filetype;
  QString command;
};


class ExportCustomDialog : public QDialog
{
  Q_OBJECT

public:
  ExportCustomDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					   WFlags f=0 );

  void setData( ExportCustomDialogData* );
  ExportCustomDialogData* data() const;

private slots:
  void okClicked();

private:
  LyXView* _view;
  
  QRadioButton* lyxRB;
  QRadioButton* latexRB;
  QRadioButton* dviRB;
  QRadioButton* postscriptRB;
  QRadioButton* asciiRB;

  QLineEdit* commandED;
};


#endif

/*
 * $Log: ExportCustomDialog.h,v $
 * Revision 1.2  1998/03/15 07:11:11  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/01/14 22:26:41  kalle
 * ExportCustomDialog
 *
 */
