// This file is part of KLyX, The Document Processor
//
// Copyright (C) 1995 Matthias Ettrich
// Copyright (C) 1997-1999 KLyX Team

#ifndef _INSERTBIBITEMDIALOG_H
#define _INSERTBIBITEMDIALOG_H


#include <qdialog.h>


class QLabel;
class QLineEdit;

class LyXView;
class InsetCommand;


/**
 * @ short Enter bibliography item
 *
 * This dialog is used to enter new bibliography items when using thebibliography
 * standardwise or used to enter the databases and the bib-style when using bibtex.
 *
 * That's why we need the ability to change the labels from the outside.
 *
 * @version 1998/08/11
 */
class InsertBibitemDialog : public QDialog
{
    Q_OBJECT

public:

    InsertBibitemDialog ( LyXView* view, QWidget * parent=0, 
			  const char * name=0, WFlags f=0 );

    void setInset( InsetCommand* _inset ) { inset = _inset; }

    /**
     * Set new label text and resize to show the whole label.
     */
    void setFirstLabel( const char* );

    /**
     * Set new label text and resize to show the whole label.
     */
    void setSecondLabel( const char* );

    void setFirstEdit( const char* );

    void setSecondEdit( const char* );


private slots:

    void okClicked();


private:

    LyXView *_view;
    InsetCommand *inset;
  
    QLabel *firstLA;
    QLineEdit *firstED;
    QLabel *secondLA;
    QLineEdit *secondED;
};



#endif


// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
