/*
 * $Id: ParagraphExtraDialog.h,v 1.4 1998/03/04 21:49:37 kalle Exp $
 */

#ifndef _PARAGRAPHEXTRADIALOG_H
#define _PARAGRAPHEXTRADIALOG_H

#include <qdialog.h>
#include <qstring.h>

#include "lyxdummies.h"

class QButtonGroup;
class QCheckBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;

struct ParagraphExtraDialogData
{
  enum ExtraOptions {IndentedParagraph, Minipage, Floatflt };
  ExtraOptions extra_options;
  QString length;
  QString percent;
  enum Alignment { Top, Middle, Bottom };
  Alignment alignment;
  bool hfill_between_minipages;
  bool start_new_minipage;
};


class ParagraphExtraDialog : public QDialog
{
  Q_OBJECT

public:
  ParagraphExtraDialog ( QWidget * parent=0, const char * name=0, 
						 WFlags f=0 ) ;

  void setData( ParagraphExtraDialogData* data );
  ParagraphExtraDialogData* data() const;

  void deactivateButtons();
  void activateButtons();
  void disable();
  void enable();
  void updateData();
  void applyData();

private slots:
  void indentToggled( bool );
  void minipageToggled( bool );
  void floatfltToggled( bool on );

private:
  bool checkInputWidth();

  QButtonGroup* extraoptionsBG;
  QRadioButton* indentedparagraphRB;
  QRadioButton* minipageRB;
  QRadioButton* floatfltRB;
  QGroupBox* widthGB;
  QLineEdit* lengthED;
  QLabel* lengthLA;
  QLabel* percentLA;
  QLineEdit* percentED;
  QButtonGroup* alignmentBG;
  QRadioButton* topRB;
  QRadioButton* middleRB;
  QRadioButton* bottomRB;
  QCheckBox* hfillminipageCB;
  QCheckBox* startminipageCB;
  QPushButton* okPB;
  QPushButton* cancelPB;
};


#endif

/*
 * $Log: ParagraphExtraDialog.h,v $
 * Revision 1.4  1998/03/04 21:49:37  kalle
 * More Qt-ified
 *
 * Revision 1.3  1998/02/28 18:01:34  kalle
 * Kalle: Made ParagraphExtraDialog work and added Floatflt button
 *
 * Revision 1.2  1998/01/28 22:44:22  kalle
 * activated new ParagraphExtraDialog (still buggy, and I don't understand
 * the options anyway :-))
 * 1626 XForms calls left (this was a good one)
 * fixed a bug in the document layout dialog
 *
 * Revision 1.1.1.1  1997/12/14 21:19:34  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/11/26 16:11:15  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.1  1997/11/15 22:11:54  kalle
 * ParagraphExtraDialog added
 *
 */
