/* This file is Copyright (C) 1998 Matthias Kalle Dalheimer (kalle@kde.org)

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
/*
 * $Id: QKStartupScreen.h,v 1.1 1998/01/29 21:26:26 kalle Exp $
 */

#ifndef _QKSTARTUPSCREEN_H
#define _QKSTARTUPSCREEN_H

#include <qpixmap.h>
#include <qwidget.h>
class QLabel;
class QTimer;

/**
  * QKStartupScreen shows a pixmap as a "spash screen" for a given
  * amount of time and destroys it self automatically afterwards. You
  * may only create it on the heap, otherwise you will get a
  * compile-time error. If you want to destroy the startup screen
  * before its time is up, call destroy().
  * @author Kalle Dalheimer, <kalle@kde.org>
  */
class QKStartupScreen : public QWidget
{
friend class QBlahDummy; // avoids a compiler warning

  Q_OBJECT

public:
  /** Constructor. Pass the name of the pixmap you want to load.
	* The pixmap is shown automatically for the given amount of time.
	* @param pixmap: the pixmap to be shown
	* @param seconds the number of seconds the screen will be shown
	*/
  QKStartupScreen( const char* pixmap, int seconds );

public slots:
  /** Call this if you want to remove the startup screen before his
	* time is up.
	*/
  void destroy();

private:
  ~QKStartupScreen(); // destructor is private to forbid creation on
					 // the stack

  QPixmap pixmap;
  QLabel* label;
  QTimer* timer;
};

#endif

/*
 * $Log: QKStartupScreen.h,v $
 * Revision 1.1  1998/01/29 21:26:26  kalle
 * Added startup screen
 *
 */
