/*
 * $Id $
 */

#include <kapp.h>

#include "debug.h"
#include "ScreenFontsDialog.h"
#include "ScreenOptionsTabDialog.h"
#include "ScreenToolbarsDialog.h"

ScreenOptionsTabDialog::ScreenOptionsTabDialog( QWidget* parent, const char* name ) :
  QTabDialog( parent, name, true )
{
  fontspage = new ScreenFontsDialog( this, "ScreenFontsPage" );
  addTab( fontspage, i18n( "&Fonts" ) );
  toolbarspage = new ScreenToolbarsDialog( this, "ScreenToolbarsPage" );
  addTab( toolbarspage, i18n( "&Toolbars" ) );

  setOKButton( i18n( "OK" ) );
  setCancelButton( i18n( "Cancel" ) );
  setDefaultButton( i18n( "Defaults" ) );

  connect( this, SIGNAL( applyButtonPressed() ),
		   this, SLOT( accept() ) );
  connect( this, SIGNAL( cancelButtonPressed() ),
		   this, SLOT( reject() ) );
  connect( this, SIGNAL( defaultButtonPressed() ),
		   this, SLOT( setDefaults() ) );
};


void ScreenOptionsTabDialog::setData( ScreenOptionsTabDialogData* _data )
{
  fontspage->setData( _data->fontsdata );
  toolbarspage->setData( _data->toolbarsdata );
}

static ScreenOptionsTabDialogData tempdata;

ScreenOptionsTabDialogData* ScreenOptionsTabDialog::data() const
{
  tempdata.fontsdata = fontspage->data();
  tempdata.toolbarsdata = toolbarspage->data();

  return &tempdata;
}


void ScreenOptionsTabDialog::setDefaults()
{
    KDEBUG( KDEBUG_WARN, KLYX_DEBUG_MISSING, "Sorry, not implemented: ScreenOptionsTabDialog::setDefaults()" );
#warning Not implemented: ScreenOptionsTabDialog::setDefaults()
}

