// -*- mode: C++ -*-
/* This file is part of*
 * ======================================================
 *
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *                        1996, 1997 LyX Team
 * 
 *======================================================*/

#ifndef _INSET_TOC_H
#define _INSET_TOC_H

#include <kapp.h>

#include "insetcommand.h"

// Created by Lgb 970527

/**
 * Used to insert and show table of contents
 */
class InsetTOC: public InsetCommand {
public:
	///
	InsetTOC(): InsetCommand("tableofcontents") { }
	///
	InsetTOC(Buffer *b): InsetCommand("tableofcontents"),owner(b){};
        ///
        Inset* Clone() { return new InsetTOC(owner); }
    	///
	LString getScreenLabel() const { return i18n( "Table of Contents" ); }
    
        void Edit(int, int);
        ///
	unsigned char Editable() const { return EDITABLE_NO_UNDO; }
	///
	bool Display() const { return true; }
	///
	Inset::Code LyxCode() const { return Inset::TOC_CODE; }
private:
	///
	Buffer *owner;
};

#endif
