//#include <ktablistbox.h>
//#include <kpanner.h>
//#include <kmsgbox.h>
#include <qlabel.h>
#include <qfiledlg.h>
#include <qlayout.h>

#include <kapp.h>
#include <klocale.h>

#include <stdio.h>
#include <stdlib.h>

#include "kpp_list.h"
#include "kpp_codes.h"
#include "np.h"
#include "kpp_EntryDlg.h"
#include "kpp_net.h"

pp_List::pp_List(QWidget *parent, const char *name)
  :KPanner(parent, name)
{
  QBoxLayout *qgl=new QBoxLayout(child0(), QBoxLayout::LeftToRight);
  _list=new KTabListBox(child0(), name);
  _list->setNumCols(11);
  _list->setColumn(0,"C",20);
  _list->setColumn(1,"I",20);
  _list->setColumn(2,"From",40);
  _list->setColumn(3,"To",40);
  _list->setColumn(5,"Dur",40);
  _list->setColumn(4,"Name",70);
  _list->setColumn(6,"EBT",40);
  _list->setColumn(7,"LBT",40);
  _list->setColumn(8,"EET",40);
  _list->setColumn(9,"LET",40);
  _list->setColumn(10,"TBT",40);

  n=new NPT(10);
  char *sz=new char[200];
  CHECK_PTR(sz);
  CHECK_PTR(n);
  sz[0]=0;
  n->AddProc(new Action(0,1,3,"Test"));
  n->getFmtStr(0,sz, _list->separator());

  qgl->addWidget(_list);
//  QBoxLayout *qgl2=new QBoxLayout(child1(), QBoxLayout::LeftToRight);

  _list->appendItem(sz);
//  _list->resize(_list->totalWidth()+10,250);
  _list->show();
  
  connect(_list, SIGNAL(highlighted(int, int)), this, SLOT(selectEntry(int, int)));
  connect(_list, SIGNAL(highlighted(int, int)),parent, SLOT(changeEntry(int, int)));
  delete [] sz;

   setSeparator(_list->totalWidth());
  _idx=0;
  _dlg=0;
}

pp_List::~pp_List()
{
  delete n;
  delete _list;
  //if (_dlg!=0) delete _dlg;
}


void pp_List::editEntry()
{
  if (_dlg==0) {
	char *sz=new char [20];
   _dlg=new kpp_EntryDlg;
    
   CHECK_PTR(_dlg);
   _dlg->AttachNP(n, _idx);   
	
   _dlg->setText(n->getText(_idx));
   
   sprintf(sz,"%ld", n->getDur(_idx));
   _dlg->setDur(sz);
	
   sprintf(sz,"%ld", n->getPred(_idx));
	_dlg->setPred(sz);
	
   sprintf(sz,"%ld", n->getSucc(_idx));
	_dlg->setSucc(sz);
	
   delete [] sz;
   connect( _dlg, SIGNAL( finished(bool) ), 
	     this, SLOT( processEditDlg(bool ) ) );
   _dlg->show();
  }
}

void pp_List::newEntry() 
{
   _idx=0;
   _newitem=1;
   editEntry();
}

void pp_List::selectEntry(int idx, int )
{
  _idx=idx;
}

void pp_List::deleteEntry( )
{
   _list->removeItem(_idx);
   n->DelProc(_idx);
}

void pp_List::clearAllEntries()
{
   _list->clear();
   n->Clear();
}

/* processEntry
 * --------------------------------------------------------------
 * Purpose:		Process Edit/New Dialog. The values are applied, if
 *					- OK was pressed
 *					- A NEW node is not already occupied (parallel processes
 *					  are not allowed!)
 *					 
 */
 
void pp_List::processEditDlg(bool really)
{
  if (_dlg==0) {
    printf("Oops! No dialog...\n");
    return;
  }

  if(really) {
	  n->setText(_idx, _dlg->getText());
	  n->setDur(_idx, _dlg->getDur());
	  n->setPred(_idx, _dlg->getPred());
	  n->setSucc(_idx, _dlg->getSucc());
		/* prepare list entry */
	  char *sz=new char[200];
	  sz[0]=0;
 		/* update listbox */
     if (!_newitem) {
         n->getFmtStr(_idx, sz, _list->separator());
        _list->changeItem(sz, _idx);
     } else {
        n->AddProc(new Action(_dlg->getPred(), _dlg->getSucc(), 
               	 _dlg->getDur(), _dlg->getText()));
        n->getFmtStr(_idx, sz, _list->separator());
        _list->appendItem(sz);
        _newitem=0;		/* reset flag to default */
     }
	  _list->repaint();
  }
  
  delete _dlg;	/* free dialog */
  _dlg=0;
}

void pp_List::loadFile() 
{
   doload();
}

int pp_List::doload()
{
   QString s=QFileDialog::getOpenFileName(getenv("HOME")), sb;
   if (!s.isEmpty()) {
      printf("Open: %s\n", (const char*)s);

      if (n->Count()>0)
         clearAllEntries();

      n->loadFile(s);
      printf("Load complete\n");
      AttachList(0);
      sb.sprintf("%d Processes", n->Count());
      
      emit change(sb);
      printf("List attached\n");
      return KPP_OK;
   } else {      
      return KPP_USER_CANCEL;
   }
}

int pp_List::AttachList(int ) 
{
   int i;
   char *buffer;
   buffer=new char [200];
   buffer[0]=0;
   
   for(i=0;i<n->Count();i++) {
      n->getFmtStr(i,buffer, _list->separator());
//      printf("Attach: %s\n", buffer);
      if (strlen(buffer)>0)
         _list->insertItem(buffer, _idx+i);
   }
   delete [] buffer;
   return KPP_OK;
}

int pp_List::UpdateList()
{
   int i;
   char *buffer;
   buffer=new char [200];
   
   for(i=0;i<n->Count();i++) {
      n->getFmtStr(i,buffer, _list->separator());
      _list->changeItem(buffer, i);
   }
   delete [] buffer;
   return KPP_OK;
}

void pp_List::calcTimes()
{
   n->CalcTimes();
   UpdateList();
}


void pp_List::showGantt()
{
   QGantt *g=new QGantt(0, "Gantt", n->getList(), n->TotalDur());
   g->exec();
}
