
#ifndef __KSIAGLINEEDIT_H
#define __KSIAGLINEEDIT_H

/**
 * This is simply a line edit that blocks until either a newline or focusout
 * event occurs.
 */

#include <klined.h>
#include "ksiag_table.h"

class KSiagCellEdit : public KLined
{
    Q_OBJECT
public:
    KSiagCellEdit(KSiagTable *table, QWidget *parent = 0, const char *name = 0);
    ~KSiagCellEdit(){;}
    int exec(char *buffer);
protected slots:
    void done();
    void recalcSize(const char *str);
protected:
    virtual void focusOutEvent (QFocusEvent *ev);
    KSiagTable *tbl;
    QFont font;
    bool inexec, result;
};

class KSiagLineEdit : public KLined
{
    Q_OBJECT
public:
    KSiagLineEdit (QWidget *parent=0, const char *name=0);
    int exec (char *buffer);
public slots:
    void done();
    void cancel();
protected:
    virtual void focusOutEvent (QFocusEvent *ev);

    bool inexec, result;
};

#endif

