/* newdeposit.h
 *
 * Andreas Wst
 *
 */

#include "newdeposit.moc"

Newdeposit::Newdeposit (QWidget *parent, const char *name)
     : QDialog (parent, name, TRUE)
{
  setCaption ("Open new deposit");
 
  bg = new QButtonGroup (this, "bg");
  bg->setGeometry (10, 10, 360, 110);
  
  le = new QLineEdit (bg, "le");
  le->setGeometry (190, 30, 150, 20);
  le->setText ("mydeposit.deposit");
  le->setMaxLength (26);

  combo = new QComboBox (bg, "combo");
  combo->setGeometry (190, 60, 150, 20);
  combo->insertItem ("Euro E");
  combo->insertItem ("USDollar $");
  combo->insertItem ("Yen Y");

  QLabel *l1 = new QLabel ("Name (with suffix .deposit) :", bg, "label");
  l1->setGeometry (10, 30, 160, 20);
  l1->setAlignment (AlignRight);  

  QLabel *l2 = new QLabel ("Currency :", bg, "label");
  l2->setGeometry (100, 60, 70, 20);
  l2->setAlignment (AlignRight);

  cancel = new QPushButton ("Cancel", this, "cancel");
  cancel->setGeometry (200, 130, 70, 30);
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));
 
  ok = new QPushButton ("OK", this, "cancel");
  ok->setGeometry (300, 130, 70, 30);
  connect (ok, SIGNAL (clicked ()), SLOT (okPressed ()));
}

Newdeposit::~Newdeposit ()
{
}

void Newdeposit::okPressed ()
{
  QString s (getenv ("HOME"));
  s += "/stocks/";
  s += le->text ();
  
  // Abfrage, ob bereits deposit mit gleichem namen existiert
  QFile file (s.data ());
  if (file.exists () == TRUE)
  {
    QString msg;
    msg.sprintf ("Deposit %s \nalready exists !", s.data ()); 
    QMessageBox::critical (this, "Error", msg, "&Ok");
    return;
  }

  emit (emitDepositData (s, combo->currentItem ()));
  emit (accept ());
}
 
