/**************************************************************************
 * $Id: samplin.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SAMPLIN_H
#define SAMPLIN_H

#include <config.h>
#include <qstring.h>

#define SAMPLIN_VERSION VERSION

#define DEFAULT_SCRIPT "default.Script"
#define DEVICES_FILE "SampLin.devices"
#define SCRIPT_EXT ".Script"

//#define OLD_GRAPH_EXT ".1.SampLin"
//#define GRAPH_EXT ".Graph"
//#define EXPORT_TXT_EXT ".txt"
//#define EXPORT_PIC_EXT ".pic"
//#define EXPORT_BMP_EXT ".bmp"
//#define GRAPH_DATA_ID "SampLin_d_1.2"
//#define GRAPH_DATA_ID3 "SampLin_d_1.3"

#ifndef MAX
#define MAX(a,b) ((a>b)?a:b)
#endif

#ifndef MIN
#define MIN(a,b) ((a<b)?a:b)
#endif

void readConfig(void);
void writeConfig(void);
void createDirs(void);

struct configstruct {
   QString root_dir;
   QString data_dir;
   QString scripts_dir;
   QString cnf_dir;
   QString devices_file;
   
   int info_level;
   int mesg_win;
   
   QString edit_command;
   int ext_editor;
};

class SamplinCurve;

extern struct configstruct cnf;
extern SamplinCurve *clipboard_curve;

#endif // SAMPLIN_H
