%name SamplinParser
%{


/**************************************************************************
 * $Id: script.bison.y 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "script_all.h"     /* definitions of yabasic */

%}

%define ERROR_BODY=0;
%define DEBUG 1
%define LEX_BODY = 0
%define MEMBERS \
public: \
virtual void create_goto(char *)=0; \
virtual void create_negate(void)=0; \
virtual void create_pushdblsym(char *)=0; \
virtual void create_popdblsym(char *)=0; \
virtual void create_pushdbl(double)=0; \
virtual void create_dblbin(char)=0; \
virtual void create_dblrelop(char)=0; \
virtual void create_pushstrsym(char *)=0; \
virtual void create_popstrsym(char *)=0; \
virtual void create_concat(void)=0; \
virtual void create_pushstr(char *)=0; \
virtual void create_strrelop(char)=0; \
virtual void create_print(char)=0; \
virtual void create_myread(char)=0; \
virtual void create_prompt(char *)=0; \
virtual void create_myopen(double,char *)=0; \
virtual void create_myclose(double)=0; \
virtual void create_myswitch(double)=0; \
virtual void create_gosub(char *)=0; \
virtual void create_label(char *)=0; \
virtual void create_return(void)=0; \
virtual void create_skipper(void)=0; \
virtual void create_nop(void)=0; \
virtual void create_myend(void)=0; \
virtual void create_decide(void)=0; \
virtual void create_boole(char)=0; \
virtual void create_function(int, char *)=0; \
virtual void create_doarray(char *,int)=0; \
virtual void create_dim(char *,char)=0; \
virtual void create_restore(char *)=0; \
virtual void create_dbldata(double)=0; \
virtual void create_strdata(char *)=0; \
virtual void create_readdata(char)=0; \
virtual void create_mywait()=0; \
virtual void create_bell()=0; \
virtual void create_devopen(char *)=0; \
virtual void create_devclose(char *)=0; \
virtual void create_devrd(char *,int)=0; \
virtual void create_devrdb(char *, char *)=0; \
virtual void create_devwr(char *,int)=0; \
virtual void create_devwrb(char *, char *)=0; \
virtual void create_devctl(char *)=0; \
virtual void create_message(char)=0; \
virtual void create_plotfnc(int,char*,char*)=0;\
virtual void create_graphfnc(int,int,char*,char*)=0;\
virtual void create_addplot(int, char *,char *)=0; \
virtual void create_updateplot(int, char *, char *)=0; \
virtual void create_delplot()=0; \
virtual void create_addgraph()=0; \
virtual void create_delgraph()=0; \
virtual void create_loadgraph(int)=0; \
virtual void create_savegraph(int)=0; \
virtual void create_exportgraph(int)=0; \
virtual void create_printgraph()=0; \
virtual void create_titlegraph()=0; \
virtual void create_adddlg(char *)=0; \
virtual void create_deldlg(char *)=0; \
virtual void create_hidedlg(char *)=0; \
virtual void create_showdlg(char *)=0; \
virtual void create_progressdlg(int,int)=0; \
virtual void create_addwidget(char *, int, char *, char * )=0; \
virtual void create_mysleep()=0; \
virtual void create_multi(int )=0; \
virtual void create_timer(int )=0; \
virtual void create_cursor(int )=0;\
virtual void inccounter(void)=0; \
virtual void pushlabel(void)=0; \
virtual void poplabel(void)=0; \
virtual void swap(void)=0; \
virtual struct stackentry *pop(void)=0; \
virtual void pushgoto(void)=0; \
virtual void popgoto(void)=0;\
virtual void pushcopy(void)=0; \
virtual void pushcounter(void)=0; \
virtual void pushname(char *)=0; \
virtual void error(int, const char*)=0; \
\
enum functions { \
   MYRAN2,MYINKEY,MYREADY,MYSPOLL,MYACTIVE,MYDATE,MYTIME,ZEROARGS,MYSIN,MYASIN,MYCOS,MYACOS,MYTAN,MYATAN, \
   MYEXP,MYLOG,MYLEN,MYSTR,MYCHR,MYSQRT,MYFRAC,MYRAN,MYINT,MYVAL,MYASC, \
   ONEARGS,MYATAN2,MYLEFT,MYRIGHT,TWOARGS,MYMID \
}; \
enum arraymode { \
   CALLARRAY,ASSIGNARRAY,CALLSTRINGARRAY,ASSIGNSTRINGARRAY, CALLPTRARRAY, \
   CALLPTRSTRARRAY \
}; \
enum plotfnc { \
PLOTADD,PLOTDEL,PLOTSETDATA,PLOTSETDATAX,PLOTSETDATAY, \
PLOTSETDATAL,PLOTSETDATAXL,PLOTSETDATAYL,PLOTGETDATA,PLOTAXES,PLOTSTYLE,\
PLOTPEN, PLOTSYMBOL\
}; \
enum graphfnc { \
GRAPHCOLORS, GRAPHAXISTITLE, GRAPHTITLE, GRAPHCOMMENT, GRAPHLEGEND, GRAPHAXISSTYLE, GRAPHAXISFLAGS, \
GRAPHAXISSCALE \
}; \
int errorlevel; \
int myflag;\
struct command *lastcommand; \
int yylineno; \

%union {
  double number;        /* double number */
  int token;            /* token of command */
  char *string;         /* quoted string */
  char *symbol;         /* general symbol */
  char *strsym;         /* string symbol */
  char *arraysym;       /* array symbol */
  char *arraystrsym;
}

%type <number> step_part
%type <number> const
%type <number> hashed_number

//%token <number> NUMBER
%token <number> DECNUMBER
%token <number> HEXNUMBER
%token <symbol> SYMBOL
%token <strsym> STRSYM
%token <string> STRING
%token <arraysym> ARRAYSYM
%token <arraystrsym> ARRAYSTRSYM
%token <sep> SEP

%token FOR TO STEP NEXT GOTO GOSUB LABEL ON 
%token IF THEN ELSE ENDIF
%token PRINT INPUT RETURN DIM END
%token AND OR NOT
%token NE LE GE LT GT EQ
%token READ DATA RESTORE
%token OPEN CLOSE
%token WINDOW DOT LINE CIRCLE TEXT CLEAR PRINTER
%token WAIT BELL EOFILE

%token SIN ASIN COS ACOS TAN ATAN EXP LOG SQRT
%token INT FRAC RAN LEN VAL LEFT_ RIGHT_ MID STR LEN CHR INKEY ASC

%token DEVRD DEVWR DEVOPEN DEVCLOSE DEVCTL DEVSPOLL

%token MESSAGE M_INFO M_WARNING M_ERROR

%token ADDXPLOT ADDYPLOT ADDXYPLOT UPDATEXPLOT UPDATEYPLOT UPDATEXYPLOT DELPLOT TITLEGRAPH

%token ADDGRAPH DELGRAPH LOADGRAPH SAVEGRAPH EXPORTGRAPH PRINTGRAPH

%token ADDPLOT SETPLOTDATA GETPLOTDATA SETPLOTAXES SETPLOTSTYLE SETPLOTPEN SETPLOTSYMBOL
%token SETGRAPHTITLE SETGRAPHCOMMENT SETAXISTITLE SETAXISFLAGS SETAXISSCALE SETAXISSTYLE
%token SETGRAPHLEGEND SETGRAPHCOLORS
%token AUTO REF INV SYM FLT

%token LEFT, RIGHT, TOP, BOTTOM

%token ADDDLG DELDLG HIDEDLG SHOWDLG PROGRESSDLG ADDWIDGET TEXT BUTTON SWITCH LCD LED

%token DLGACTIVE

%token FRAME WHEEL SELECT GRAPH KNOB LEVEL SLIDER

%token SLEEP

%token MULTI OFF IDLE DEVREADY CURSOR DEFAULT TIMER DATE TIME

%left OR
%left AND
%left NOT

%left '-' '+'
%left '*' '/'
%left '^'
%left '|' '&' '~'

%nonassoc UMINUS

%%

program: statement_list EOFILE {YYACCEPT;}
  ;

statement_list: statement
  | statement {if (errorlevel<=ERROR) {YYABORT;}}
    SEP statement_list
  ;

statement:  /* empty */
  | string_assignment 
  | assignment
  | for_loop 
  | if_clause
  | GOTO SYMBOL {create_goto($2);}
  | GOSUB SYMBOL {create_gosub($2);}
  | ON SYMBOL {create_pushdblsym($2);} GOTO {create_skipper();}
    goto_list {create_nop();}
  | ON SYMBOL {create_pushdblsym($2);} GOSUB {create_skipper();} 
    gosub_list {create_nop();}
  | LABEL SYMBOL {create_label($2);}
  | OPEN hashed_number ',' string_expression ',' STRING
    {create_myopen($2,$6);}
  | OPEN hashed_number ',' string_expression
    {create_myopen($2,"a");}
  | CLOSE hashed_number {create_myclose($2);}
  | PRINT stream printlist semicolon {}
  | INPUT inputparams  {lastcommand->args=TRUE;}
  | READ readlist
  | DATA datalist
  | RESTORE {create_restore("");}
  | RESTORE SYMBOL {create_restore($2);}
  | RETURN {create_return();}
  | DIM dimlist 
  | WAIT expression {create_mywait();}
  | BELL {create_bell();}
  | END {create_myend();}
  | DEVWR devwrparams
  | DEVRD devrdparams
  | DEVOPEN devopenparams
  | DEVCLOSE devcloseparams
  | DEVCTL devctlparams
  | MESSAGE messageparams
//  | ADDXPLOT addxplotparams
//  | ADDYPLOT addyplotparams
//  | ADDXYPLOT addxyplotparams  
//  | UPDATEXPLOT updatexplotparams
//  | UPDATEYPLOT updateyplotparams
//  | UPDATEXYPLOT updatexyplotparams  
  | SLEEP expression {create_mysleep();}
  | ADDGRAPH addgraphparams
  | DELGRAPH delgraphparams
  | LOADGRAPH loadgraphparams
  | SAVEGRAPH savegraphparams  
  | EXPORTGRAPH exportgraphparams
  | PRINTGRAPH printgraphparams  
  | ADDPLOT addplotparams
  | DELPLOT delplotparams
  | SETPLOTDATA setplotdataparams
  | GETPLOTDATA getplotdataparams
  | SETPLOTAXES setplotaxesparams
  | SETAXISTITLE setaxistitleparams
  | SETAXISSCALE setaxisscaleparams
  | SETAXISFLAGS setaxisflagsparams
  | SETAXISSTYLE setaxisstyleparams
  | SETGRAPHTITLE setgraphtitleparams
  | SETGRAPHCOMMENT setgraphcommentparams
  | SETGRAPHLEGEND setgraphlegendparams
  | SETGRAPHCOLORS setgraphcolorsparams
  | SETPLOTSTYLE setplotstyleparams
  | SETPLOTPEN setplotpenparams
  | SETPLOTSYMBOL setplotsymbolparams
  | ADDDLG adddlgparams
  | DELDLG deldlgparams  
  | HIDEDLG hidedlgparams  
  | SHOWDLG showdlgparams
  | PROGRESSDLG progressdlgparams
  | ADDWIDGET addwidgetparams
  | MULTI multiparams
  | IDLE {create_multi(1);}
  | TIMER timerparams
  | CURSOR cursorparams
//  | TITLEGRAPH titlegraphparams
;

string_assignment: STRSYM EQ string_expression {create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' EQ string_expression {create_doarray($1,ASSIGNSTRINGARRAY);}
  ;

string_expression: STRSYM {create_pushstrsym($1);}
  | string_function;
  | STRING {if (errorlevel<=ERROR) {YYABORT;} create_pushstr($1);}
  | string_expression '+' string_expression {create_concat();}
  | STRSYM '[' {pushcounter();} indexlist ']' {create_doarray($1,CALLSTRINGARRAY);}
  | '(' string_expression ')'
  ;

string_function: LEFT_ '(' string_expression ',' expression ')' {create_function(MYLEFT,0);}
  | RIGHT_ '(' string_expression ',' expression ')' {create_function(MYRIGHT,0);}
  | MID '(' string_expression ',' expression ',' expression ')' {create_function(MYMID,0);}
  | STR '(' expression ')' {create_function(MYSTR,0);}
  | CHR '(' expression ')' {create_function(MYCHR,0);}
  | INKEY {create_function(MYINKEY,0);}
  | DATE {create_function(MYDATE,0);}
  | TIME {create_function(MYTIME,0);}
;

assignment: SYMBOL EQ expression {create_popdblsym($1);} 
  | SYMBOL '[' {pushcounter();} indexlist ']' EQ expression {create_doarray($1,ASSIGNARRAY);}
  ;

expression: DECNUMBER {create_pushdbl($1);}
  | HEXNUMBER {create_pushdbl($1);}
  | function
  | SYMBOL {create_pushdblsym($1);}
  | SYMBOL '[' {pushcounter();} indexlist ']' {create_doarray($1,CALLARRAY);};
  | '(' expression ')' 
  | expression '+' expression {create_dblbin('+');}
  | expression '-' expression {create_dblbin('-');}
  | expression '*' expression {create_dblbin('*');}
  | expression '/' expression {create_dblbin('/');}
  | expression '^' expression {create_dblbin('^');}
  | expression '&' expression {create_dblbin('&');}
  | expression '|'  expression {create_dblbin('|');}
  | expression '~' expression {create_dblbin('~');}
  | '-' expression %prec UMINUS {create_negate();}
  ;

function: SIN '(' expression ')' {create_function(MYSIN,0)}
  | ASIN '(' expression ')' {create_function(MYASIN,0)}
  | COS '(' expression ')' {create_function(MYCOS,0)}
  | ACOS '(' expression ')' {create_function(MYACOS,0)}
  | TAN '(' expression ')' {create_function(MYTAN,0)}
  | ATAN '(' expression ')' {create_function(MYATAN,0)}
  | ATAN '(' expression ',' expression  ')' {create_function(MYATAN2,0)}
  | EXP '(' expression ')' {create_function(MYEXP,0)}
  | LOG '(' expression ')' {create_function(MYLOG,0)}
  | SQRT '(' expression ')' {create_function(MYSQRT,0)}
  | INT '(' expression ')' {create_function(MYINT,0)}
  | FRAC '(' expression ')' {create_function(MYFRAC,0)}
  | RAN '(' expression ')' {create_function(MYRAN,0)}
  | RAN '(' ')' {create_function(MYRAN2,0)}
  | LEN '(' string_expression ')' {create_function(MYLEN,0)}
  | VAL '(' string_expression ')' {create_function(MYVAL,0)}
  | DEVREADY '(' SYMBOL ')' {create_function(MYREADY,$3)}
  | DLGACTIVE '(' SYMBOL ')' {create_function(MYACTIVE,$3)}
  | DEVSPOLL '(' SYMBOL ')' {create_function(MYSPOLL,$3)}
  | ASC '(' string_expression ')' {create_function(MYASC,0)}
;

const: DECNUMBER {$$=$1}
  | '+' DECNUMBER {$$=$2}
  | '-' DECNUMBER {$$=-$2;}
  | HEXNUMBER {$$=$1}
  | '+' HEXNUMBER {$$=$2}
  | '-' HEXNUMBER {$$=-$2;}  
  ;

dimlist: SYMBOL '[' {pushcounter();} indexlist ']' {create_dim($1,'d');}
  | dimlist ',' SYMBOL '[' {pushcounter();} indexlist ']' {create_dim($3,'d');}
  | STRSYM '[' {pushcounter();} indexlist ']' {create_dim($1,'s');}
  | dimlist ',' STRSYM '[' {pushcounter();} indexlist ']' {create_dim($3,'s');}
  ;

indexlist: expression {inccounter();}
  | indexlist ',' expression {inccounter();}
  ;
 
for_loop: FOR SYMBOL EQ expression 
            {pushname($2);create_popdblsym($2);pushgoto();create_pushdblsym($2);}
	  TO expression 
	  step_part {
	     create_dblrelop(($8>0)?'{':'}');
             create_decide();
             pushlabel();}
	  SEP
          statement_list {
             create_pushdbl($8);
	     create_pushdblsym($2);	
             create_dblbin('+');
	     create_popdblsym($2);
             swap();popgoto();poplabel();}
          next_or_eofile next_symbol
  ;

next_or_eofile: NEXT
  | EOFILE {error(ERROR,"'next'-statement is missing"); YYABORT;}

step_part: {$$=1.0;} /* can be omitted */
  | STEP const {$$=$2;}
  ;

next_symbol:  {pop();}/* can be omitted */
  | SYMBOL {if (strcmp((char *)(pop()->pointer),$1)) {error(ERROR,"'for' and 'next' do not match"); YYABORT;}}
  ;

if_clause: IF comparison {create_decide();pushlabel();}
           THEN statement_list {pushlabel();swap();poplabel();}
           else_part {poplabel();}
           endif_or_eof
  ;

endif_or_eof: ENDIF
  | EOFILE {error(ERROR,"'endif'-statement is missing"); YYABORT;}

comparison: '(' comparison ')'
  | comparison OR comparison {create_boole('|');}
  | comparison AND comparison {create_boole('&');}
  | NOT comparison {create_boole('!');}
  | string_expression EQ string_expression {create_strrelop('=');}
  | string_expression NE string_expression {create_strrelop('!');}
  | expression EQ expression {create_dblrelop('=');}
  | expression NE expression {create_dblrelop('!');}
  | expression LT expression {create_dblrelop('<');}
  | expression LE expression {create_dblrelop('{');}
  | expression GT expression {create_dblrelop('>');}
  | expression GE expression {create_dblrelop('}');}
  ;

else_part: /* can be omitted */
  | ELSE statement_list
  ;

inputlist: input
  | inputlist ',' input
  ;

input: SYMBOL {create_pushdblsym($1);create_myread('d');create_popdblsym($1);}
  | SYMBOL '[' {pushcounter();} indexlist ']' 
    {pushcopy();create_doarray($1,CALLARRAY);create_myread('d');create_doarray($1,ASSIGNARRAY);}
  | STRSYM {create_pushstrsym($1);create_myread('s');create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' 
    {pushcopy();create_doarray($1,CALLSTRINGARRAY);create_myread('s');create_doarray($1,ASSIGNSTRINGARRAY);}
  ;

readlist: readitem
  | readlist ',' readitem
  ;

readitem: SYMBOL {create_readdata('d');create_popdblsym($1);}
  | SYMBOL '[' {pushcounter();} indexlist ']' 
    {create_readdata('d');create_doarray($1,ASSIGNARRAY);}
  | STRSYM {create_readdata('s');create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' 
    {create_readdata('s');create_doarray($1,ASSIGNSTRINGARRAY);}
  ;

datalist: STRING {create_strdata($1);}
  | const {create_dbldata($1);}
  | datalist ','  STRING {create_strdata($3);}
  | datalist ',' const {create_dbldata($3);}
  ;

prompt: /* possible empty */ {create_prompt("?");}
  | STRING {create_prompt($1);}
  ;

printlist:  /* possible empty */
  | expression {create_print('d');}
  | printlist ',' expression {create_print('d');} 
  | string_expression {create_print('s');} 
  | printlist ',' string_expression {create_print('s');}
  ;
  
devopenparams: SYMBOL {create_devopen($1);}
  ;

devcloseparams: SYMBOL {create_devclose($1);}
  ;

devwrparams: SYMBOL ',' string_expression {create_devwr($1,0);}
  |  SYMBOL ',' string_expression ',' expression {create_devwr($1,1);}
  |  SYMBOL ',' ARRAYSYM ',' expression ',' expression {create_devwrb($1,$3);}
  ;

devrdparams: SYMBOL ',' STRSYM {create_devrd($1,0);create_popstrsym($3);} 
  |  SYMBOL ',' STRSYM ',' expression {create_devrd($1,1);create_popstrsym($3);} 
  |  SYMBOL ',' ARRAYSYM ',' expression ',' expression {create_devrdb($1,$3);}
  ;

devctlparams: SYMBOL ',' expression ',' expression {create_devctl($1);}
  ;

addplotparams: string_expression ',' string_expression {create_plotfnc(PLOTADD,0,0);}
;
setplotdataparams: string_expression ',' string_expression ',' ARRAYSYM ','
  ARRAYSYM {create_plotfnc(PLOTSETDATA,$5,$7);}
|  string_expression ',' string_expression ',' ARRAYSYM ','
  ARRAYSYM ',' expression {create_plotfnc(PLOTSETDATAL,$5,$7);}
| string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression
  {create_plotfnc(PLOTSETDATAX,$5,0);}
| string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression ',' expression
  {create_plotfnc(PLOTSETDATAXL,$5,0);}
| string_expression ',' string_expression ',' expression ',' expression ',' ARRAYSYM
  {create_plotfnc(PLOTSETDATAY,$9,0);}
| string_expression ',' string_expression ',' expression ',' expression ',' ARRAYSYM ','
  expression {create_plotfnc(PLOTSETDATAYL,$9,0);}
;
getplotdataparams: string_expression ',' string_expression ',' ARRAYSYM ','
ARRAYSYM {create_plotfnc(PLOTGETDATA,$5,$7);}
;
setplotaxesparams: string_expression ',' string_expression ',' SYMBOL ',' SYMBOL
{create_plotfnc(PLOTAXES,$5,$7);}
;
setaxistitleparams: string_expression ',' SYMBOL ',' string_expression
{create_graphfnc(GRAPHAXISTITLE,0,$3,0);}
;
setaxisscaleparams: string_expression ',' SYMBOL ',' AUTO
  {create_graphfnc(GRAPHAXISSCALE,0,$3,0);}
| string_expression ',' SYMBOL ',' AUTO ',' expression
  {create_graphfnc(GRAPHAXISSCALE,1,$3,0);}
| string_expression ',' SYMBOL ',' AUTO ',' expression ',' expression 
  {create_graphfnc(GRAPHAXISSCALE,2,$3,0);}
| string_expression ',' SYMBOL ',' expression ',' expression ',' expression
  {create_graphfnc(GRAPHAXISSCALE,3,$3,0);}
| string_expression ',' SYMBOL ',' expression ',' expression
  ',' expression ',' expression {create_graphfnc(GRAPHAXISSCALE,4,$3,0);}
| string_expression ',' SYMBOL ',' expression ',' expression ',' expression
  ',' expression ',' expression {create_graphfnc(GRAPHAXISSCALE,5,$3,0);}
;
setaxisflagsparams:  string_expression ',' SYMBOL ',' {myflag=0;} axisflaglist
{create_graphfnc(GRAPHAXISFLAGS,myflag,$3,0);}
;

axisflaglist:
   axisflag
 | axisflaglist ',' axisflag
;

axisflag:
  | LOG {myflag|=8;}
  | SYM {myflag|=2;}
  | INV {myflag|=16;}
  | REF {myflag|=1;}
  | FLT {myflag|=4;}
;

setaxisstyleparams: string_expression ',' SYMBOL ',' SYMBOL ',' expression
{create_graphfnc(GRAPHAXISSTYLE,0,$3,$5);}
|string_expression ',' SYMBOL ',' SYMBOL
{create_graphfnc(GRAPHAXISSTYLE,1,$3,$5);}
;

setgraphtitleparams: string_expression ',' string_expression
{create_graphfnc(GRAPHTITLE,0,0,0);}
;
setgraphcommentparams: string_expression ',' SYMBOL
{create_graphfnc(GRAPHCOMMENT,0,0,$3);}
| string_expression ',' SYMBOL ',' string_expression
{create_graphfnc(GRAPHCOMMENT,1,0,$3);}
;
setgraphlegendparams: string_expression ',' SYMBOL
{create_graphfnc(GRAPHLEGEND,0,0,$3);}
;
setgraphcolorsparams: string_expression ',' string_expression ','
string_expression {create_graphfnc(GRAPHCOLORS,0,0,0);}
;

//axesparams: LEFT ',' BOTTOM {create_plotfnc(PLOTAXES,yLeft,xBottom);}
//| LEFT ',' TOP {create_plotfnc(PLOTAXES,yLeft,xTop);}
//| RIGHT ',' BOTTOM {create_plotfnc(PLOTAXES,yRight,xBottom);}
//| RIGHT ',' TOP {create_plotfnc(PLOTAXES,yRight,xTop);}
//;
setplotstyleparams: string_expression ',' string_expression ',' SYMBOL {create_plotfnc(PLOTSTYLE,$5,0);}
;
setplotpenparams: string_expression ',' string_expression ',' SYMBOL ',' expression ',' string_expression {create_plotfnc(PLOTPEN,$5,0);}
;
setplotsymbolparams: string_expression ',' string_expression ',' SYMBOL ','
expression ',' expression ',' string_expression ',' string_expression {create_plotfnc(PLOTSYMBOL,$5,0);}
;

delplotparams: string_expression ',' string_expression {create_plotfnc(PLOTDEL,0,0);}
;

//addyplotparams: string_expression ',' string_expression ','  expression ',' expression ',' ARRAYSYM ',' string_expression {create_addplot(1,$9,0);}
//  ;
//addxplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression ',' string_expression {create_addplot(2,$5,0);}
//  ;
//addxyplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' ARRAYSYM ',' string_expression {create_addplot(3,$5,$7);}
//  ;

//updateyplotparams: string_expression ',' string_expression ','  expression ',' expression ',' ARRAYSYM ',' string_expression {create_updateplot(1,$9,0);}
//  ;
//updatexplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression ',' string_expression {create_updateplot(2,$5,0);}
//  ;
//updatexyplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' ARRAYSYM ',' string_expression {create_updateplot(3,$5,$7);}
//  ;

//delplotparams: string_expression ',' string_expression {create_delplot();}
//  ;    
  
addgraphparams: string_expression {create_addgraph();}
  ;
  
delgraphparams: string_expression {create_delgraph();}
  ;  

loadgraphparams: string_expression {create_loadgraph(0);}
  | string_expression ',' string_expression {create_loadgraph(1);}
  ;

savegraphparams: string_expression {create_savegraph(0);}
  | string_expression ',' string_expression {create_savegraph(1);}
  ;
  
exportgraphparams: string_expression {create_exportgraph(0);}
  | string_expression ',' string_expression {create_exportgraph(1);}
  ;
  
printgraphparams: string_expression {create_printgraph();}
  ;  

//titlegraphparams: string_expression ',' string_expression ',' string_expression ',' string_expression {create_titlegraph();}
//  ;    
  
adddlgparams: SYMBOL ',' string_expression {create_adddlg($1);}
  ;
  
deldlgparams: SYMBOL {create_deldlg($1);}
  ;    

hidedlgparams: SYMBOL {create_hidedlg($1);}
  ;    

showdlgparams: SYMBOL {create_showdlg($1);}
  ;    

progressdlgparams: string_expression ',' expression {create_progressdlg(0,0);}
  | expression {create_progressdlg(1,0);}
  ;

addwidgetparams: 
//SYMBOL ',' TEXT ',' expression ',' expression ','
//    expression ',' expression ',' STRSYM
//    {create_addwidget($1,WIDGET_TEXT,$13,0);}
//  |
   SYMBOL ',' TEXT ',' expression ',' expression ','
    expression ',' expression ',' string_expression
    {create_addwidget($1,WIDGET_TEXT,0,0);}    
  | SYMBOL ',' INPUT ',' expression ',' expression ',' expression ','
    expression ',' STRSYM {create_addwidget($1,WIDGET_INPUT,$13,0);} 
  | SYMBOL ',' INPUT ',' expression ',' expression ',' expression ','
    expression ',' STRSYM '[' {pushcounter();} indexlist ']' 
    {create_doarray($13,CALLPTRSTRARRAY);
    create_addwidget($1,WIDGET_INPUTA,$13,0);} 
  | SYMBOL ',' BUTTON ',' expression ',' expression ',' expression ','
    expression ',' string_expression ',' SYMBOL {create_addwidget($1,
    WIDGET_BUTTON, $15,0);}
  | SYMBOL ',' SWITCH ',' expression ',' expression ',' expression ','
    expression ',' string_expression ',' SYMBOL ',' SYMBOL 
    {create_addwidget($1,WIDGET_SWITCH,$15,$17);}
  | SYMBOL ',' LCD ',' expression ',' expression ',' expression ','
    expression ',' expression ',' expression ',' SYMBOL ',' string_expression
    {create_addwidget($1, WIDGET_LCD,$17,0);}
  | SYMBOL ',' LED ',' expression ',' expression ',' expression ','
    expression ',' SYMBOL ',' string_expression ',' string_expression {create_addwidget($1, WIDGET_LED,$13,0);}
  | SYMBOL ',' LED ',' expression ',' expression ',' expression ','
    expression ',' SYMBOL 
    '[' {pushcounter();} indexlist ']' 
    {create_doarray($13,CALLPTRARRAY);}    
    ',' string_expression ',' string_expression
    {create_addwidget($1, WIDGET_LEDA,$13,0);}    
  | SYMBOL ',' FRAME ',' expression ',' expression ',' expression ','
    expression ',' expression ',' expression {create_addwidget($1,
    WIDGET_FRAME,0,0);}

  | SYMBOL ',' WHEEL ',' expression ',' expression ',' expression ','
    expression ',' expression ',' expression ',' expression ',' expression ','
    SYMBOL {create_addwidget($1, WIDGET_WHEEL,0,$21);}    

  | SYMBOL ',' SELECT ',' expression ',' expression ',' expression ','
    expression ',' ARRAYSTRSYM ',' SYMBOL {create_addwidget($1,
    WIDGET_SELECT, $13,$15);}    

  | SYMBOL ',' GRAPH ',' expression ',' expression ',' expression ',' expression
  ',' string_expression
  {create_addwidget($1, WIDGET_GRAPH, 0,0);}

  | SYMBOL ',' KNOB ',' expression ',' expression ',' expression ',' expression
  ',' expression ',' expression ',' expression ',' SYMBOL
  {create_addwidget($1, WIDGET_KNOB, 0, $19);}
  
  | SYMBOL ',' LEVEL ',' expression ',' expression ',' expression ',' expression
  ',' expression ',' expression ',' expression ',' string_expression ','
  SYMBOL ',' expression
  {create_addwidget($1, WIDGET_LEVEL, 0, $21);}

  | SYMBOL ',' SLIDER ',' expression ',' expression ',' expression ',' expression
  ',' expression ',' expression ',' expression ',' SYMBOL ',' expression
  {create_addwidget($1, WIDGET_SLIDER, 0, $19);}
;    

multiparams: ON {create_multi(1);}
  | OFF {create_multi(0);}
;

timerparams: ON {create_timer(1);}
  | OFF {create_timer(0);}
;

cursorparams: WAIT {create_cursor(1);}
  | DEFAULT {create_cursor(0);}
;

messageparams:  /* possible empty */
  | string_expression {create_message('i');}
  | M_INFO ',' string_expression {create_message('i');}
  | M_WARNING ',' string_expression {create_message('w');}
  | M_ERROR ',' string_expression {create_message('e');}
  ;

inputparams: stream prompt inputlist

stream: /* possible empty */ {create_myswitch(0.0);}
  | '#' DECNUMBER {create_myswitch($2);}
  ;

hashed_number: '#' DECNUMBER {$$=$2;}
  | DECNUMBER {$$=$1;} /* need not contain hash */
  ;

semicolon: /* can be left out */ {create_print('n');}
  | ';'
  ;

goto_list: SYMBOL {create_goto($1);}
  | goto_list ',' SYMBOL {create_goto($3);}
  ;

gosub_list: SYMBOL {create_gosub($1);}
  | gosub_list ',' SYMBOL {create_gosub($3);}
  ;
