/**************************************************************************
 * $Id: GraphWindow.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphWindow.h"
#include "MainWidget.h"

#include <qmessagebox.h>
#include <knewpanner.h>

#include <GraphWindow.moc>

GraphWindow::GraphWindow ( QWidget* parent, const char* name, uint id )
:MainWidget( parent, name )
{
   static QStrList lst;
   KIconLoader IconLoader;

   win_id=id;
   setMinimumSize(450,270);
   setIcon(IconLoader.loadIcon("SampLin.xpm"));
   
   toolbar = new KToolBar(this);
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-open.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(loadGraph()), TRUE, klocale->translate("Open graph"));
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-save.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(saveGraph()), TRUE, klocale->translate("Save graph"));
   toolbar->insertButton(IconLoader.loadIcon("samplin-print.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(printGraph()), TRUE, klocale->translate("Print graph"));
   toolbar->insertSeparator();
   toolbar->insertSeparator();
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-copy.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(editCopy()), TRUE, klocale->translate("Copy"));   
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-cut.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(editCut()), TRUE, klocale->translate("Cut"));
   toolbar->insertButton(IconLoader.loadIcon("samplin-paste.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(editPaste()), TRUE, klocale->translate("Paste"));
   toolbar->insertSeparator();
   toolbar->insertSeparator();
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-cross.xpm"), 1, SIGNAL(clicked()),
			 this,
			 SLOT(closeGraph()), TRUE, klocale->translate("Close graph"));
   toolbar->alignItemRight(1,TRUE);
   toolbar->setBarPos(KToolBar::Top);
   addToolBar(toolbar);

   graphpanel = new GraphPanel(this,name);

   QPopupMenu *m_export = new QPopupMenu;
   CHECK_PTR( m_export );
   m_export->insertItem( "&Text data", graphpanel, SLOT(exportData()) );   
   m_export->insertItem( "&Qt picture", graphpanel, SLOT(exportPic()) );   
   m_export->insertItem( "&BMP bitmap", graphpanel, SLOT(exportBMP()) );   
   
   QPopupMenu *m_file = new QPopupMenu;
   CHECK_PTR( m_file );
   m_file->insertItem( "&Open", this, SLOT(loadGraph()), CTRL+Key_O );
   m_file->insertItem( "&Save", this, SLOT(saveGraph()), CTRL+Key_S );
   m_file->insertItem( "Save &as", this, SLOT(saveAsGraph()));
   m_file->insertItem( "&Export", m_export, CTRL+Key_E );
   m_file->insertItem( "&Print", this, SLOT(printGraph()), CTRL+Key_P );
   m_file->insertSeparator();
//   m_file->insertItem( "Open as &template", this, SLOT(loadTempl()) );
//   m_file->insertItem( "Save &default template", this, SLOT(saveTempl()) );
//   m_file->insertSeparator();
   m_file->insertItem( "&Close", this, SLOT(closeGraph()), CTRL+Key_W );
   
   QPopupMenu *m_edit = new QPopupMenu;
   CHECK_PTR( m_edit );
   m_edit->insertItem( "&Copy", this, SLOT(editCopy()), CTRL+Key_C );   
   m_edit->insertItem( "&Paste", this, SLOT(editPaste()), CTRL+Key_V );
   m_edit->insertItem( "C&ut", this, SLOT(editCut()), CTRL+Key_X );
   m_edit->insertSeparator();
   m_edit->insertItem( "&Rename", this, SLOT(editRename()) );

   QPopupMenu *m_axes = new QPopupMenu;
   CHECK_PTR( m_axes );
   m_axes->insertItem( "X bottom", graphpanel, SLOT(propXBAxis()) );   
   m_axes->insertItem( "Y left", graphpanel, SLOT(propYLAxis()) );   
   m_axes->insertItem( "X top", graphpanel, SLOT(propXTAxis()) );   
   m_axes->insertItem( "Y right", graphpanel, SLOT(propYRAxis()) );   
   
   QPopupMenu *m_prop = new QPopupMenu;
   CHECK_PTR( m_prop );
   m_prop->insertItem( "&Current object", graphpanel, SLOT(propCurrent()) );
   m_prop->insertSeparator();
   m_prop->insertItem( "&Graph", graphpanel, SLOT(propGraph()) );   
   m_prop->insertItem( "&Bottom axis", graphpanel, SLOT(propXBAxis()) );   
   m_prop->insertItem( "&Left axis", graphpanel, SLOT(propYLAxis()) );   
   m_prop->insertItem( "&Top axis", graphpanel, SLOT(propXTAxis()) );   
   m_prop->insertItem( "&Right axis", graphpanel, SLOT(propYRAxis()) );   
   

   
   QPopupMenu *m_help = new QPopupMenu;
   CHECK_PTR( m_help );
   
   menubar = new KMenuBar(this, "MenuBar");
   menubar->insertItem( "&File", m_file );
   menubar->insertItem( "&Edit", m_edit );   
   menubar->insertItem( "&Properties", m_prop );   
   menubar->insertSeparator();
   menubar->insertItem( "&Help", m_help );   
   setMenu(menubar);
   
   statusbar = new KStatusBar(this);
   statusbar->insertItem("Object:                                                      ", ID_OBJECT);
   statusbar->insertItem("Position:                               ", ID_POSITION);
//   statusbar->insertItem("", ID_COMMON);
   statusbar->setInsertOrder(KStatusBar::LeftToRight);
   statusbar->setBorderWidth(2);
   

   
   setStatusBar(statusbar);


   connect(graphpanel, SIGNAL(pointShow(int,float,float)),this,SLOT(pointShowSlot(int, float, float)));
   connect(graphpanel, SIGNAL(objectChange(int, uint)),this,SLOT(objectSlot(int, uint)));
   setView(graphpanel);
   objectSlot(0,0);
   
/*   KNewPanner *panner;
   QWidget *w1,*w2;
   
  
   panner = new KNewPanner(this, "panner");

   w1 = new Graph(panner);   
   w2 = new KTreeList(panner);
   panner->activate(w1,w2);
   panner->setLabels("Graph", "Options");
   panner->showLabels(TRUE);
   setView(panner);*/
   setId(id);
   updateCaption();
}


GraphWindow::~GraphWindow()
{
   delete   toolbar;
   delete   statusbar;   
   delete   menubar;
   delete   graphpanel;
}

void GraphWindow::resizeEvent( QResizeEvent *e )
{
   MainWidget::resizeEvent(e);
}


void GraphWindow::paintEvent(QPaintEvent *)
{

}

void GraphWindow::closeGraph()
{
   close();
}


void GraphWindow::printGraph()
{
   graphpanel->print();
}

void GraphWindow::editCut()
{
   graphpanel->editCut();
}

void GraphWindow::editPaste()
{
   graphpanel->editPaste();
}

void GraphWindow::editRename()
{
   graphpanel->editRename();
}

void GraphWindow::editCopy()
{
   graphpanel->editCopy();
}


void GraphWindow::pointShowSlot(int button, float x, float y)
{
char str[64];
   
   if(button==LeftButton){
      sprintf(str,"Position: [ %.0f, %.0f ]",x,y);
      statusbar->changeItem(str,ID_POSITION);
   }
   
}

void GraphWindow::loadTempl()
{
   graphpanel->loadTempl();
}

void GraphWindow::saveTempl()
{
   graphpanel->saveTempl();
}

void GraphWindow::loadGraph()
{

   graphpanel->load();
   updateCaption();
}

void GraphWindow::saveGraph()
{
   graphpanel->save();
   updateCaption();
}
void GraphWindow::saveAsGraph()
{
   graphpanel->saveAs();
   updateCaption();
}

void GraphWindow::exportData()
{

   graphpanel->exportData();
      
}

void GraphWindow::exportPic()
{

   graphpanel->exportPic();
      
}



void GraphWindow::updateCaption(void)
{
   QString num;
   if(graphpanel!=NULL)
     num.setNum(getId());
     setCaption(QString("SampLin Graph (")+num+"."+name()+") "/*+QString(graphpanel->label())*/+" ["+graphpanel->fileName()+"]");
   
}

void GraphWindow::closeEvent( QCloseEvent *)
{

   if(graphpanel->isSaved()==FALSE)
     switch( QMessageBox::information( this, "Graph window",
				      "Session contains unsaved data\n"
				      "Do you want to save it before closing ?",
				      "&Save", "&Don't Save", "&Cancel",
				      0, 2 ) ) {
	
      case 0:   saveGraph();
	        break;
      case 1:
	        break;
	
      case 2:   return;
  
     }
//   debug("loc 1");
   emit closeSignal(win_id);
//   debug("loc 2");
   delete this;  
//   debug("loc 3");
}

void GraphWindow::objectSlot(int obj, uint key)
{
   QString s,tmp;
   
   switch(obj){
    case OBJ_GRAPH:
      s="Object: Graph";
      break;
    case OBJ_XBOTTOM:
      s="Object: Bottom axis";
      break;
    case OBJ_XTOP:
      s="Object: Top axis";
      break;
    case OBJ_YLEFT:
      s="Object: Left axis";
      break;
    case OBJ_YRIGHT:
      s="Object: Right axis";
      break;
    case OBJ_SERIES:
      tmp=graphpanel->curveName(key);
//      debug("key:%u,name:%s",key,tmp.data());
      if(strlen(tmp)==0)tmp=" ";
      s=QString("Object: Series [")+tmp+"]";
      break;
    case OBJ_NONE:
    default:
      s="Object:";
      break;
   }
   statusbar->changeItem(s,ID_OBJECT);
}
