/**************************************************************************
 * $Id: GraphWindow.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphWindow.h"
#include "MainWidget.h"
#include "About.h"

#include <qmessagebox.h>
#include <knewpanner.h>

#include <GraphWindow.moc>

#define TOOLBAR_ID 1
#define STATUSBAR_ID 2

GraphWindow::GraphWindow ( QWidget* parent, const char* name, uint id )
:KTMainWindow/*MainWidget*/(/* parent,*/ /*"SampLinGraph"*/  name )
{
   static QStrList lst;
   KIconLoader IconLoader;

   win_id=id;
   setMinimumSize(450,270);
   setIcon(IconLoader.loadIcon("SampLin.xpm"));
   
   toolbar = new KToolBar(this);
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-open.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(loadGraph()), TRUE, i18n("Open graph"));
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-save.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(saveGraph()), TRUE, i18n("Save graph"));
   toolbar->insertButton(IconLoader.loadIcon("samplin-print.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(printGraph()), TRUE, i18n("Print graph"));
   toolbar->insertSeparator();
   toolbar->insertSeparator();
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-copy.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(editCopy()), TRUE, i18n("Copy"));   
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-cut.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(editCut()), TRUE, i18n("Cut"));
   toolbar->insertButton(IconLoader.loadIcon("samplin-paste.xpm"), 0, SIGNAL(clicked()),
			 this,
			 SLOT(editPaste()), TRUE, i18n("Paste"));
   toolbar->insertSeparator();
   toolbar->insertSeparator();
   
   toolbar->insertButton(IconLoader.loadIcon("samplin-cross.xpm"), 1, SIGNAL(clicked()),
			 this,
			 SLOT(closeWindow()), TRUE, i18n("Close graph"));
   toolbar->alignItemRight(1,TRUE);
   toolbar->setBarPos(KToolBar::Top);
   addToolBar(toolbar);

   graphpanel = new GraphPanel(this,name);

   QPopupMenu *m_import = new QPopupMenu;
   CHECK_PTR( m_import );
   m_import->insertItem( i18n("&ASCII data"), graphpanel, SLOT(importASCII()) );   
   
   QPopupMenu *m_export = new QPopupMenu;
   CHECK_PTR( m_export );
   m_export->insertItem( i18n("&ASCII data"), graphpanel, SLOT(exportASCII()) );   
   m_export->insertItem( i18n("&Qt picture"), graphpanel, SLOT(exportPic()) );   
   m_export->insertItem( i18n("&BMP bitmap"), graphpanel, SLOT(exportBMP()) );   
   
   QPopupMenu *m_file = new QPopupMenu;
   CHECK_PTR( m_file );
   m_file->insertItem( i18n("&Open"), this, SLOT(loadGraph()), CTRL+Key_O );
   m_file->insertItem( i18n("&Save"), this, SLOT(saveGraph()), CTRL+Key_S );
   m_file->insertItem( i18n("Save &as"), this, SLOT(saveAsGraph()));
   m_file->insertItem( i18n("&Import"), m_import, CTRL+Key_I );
   m_file->insertItem( i18n("&Export"), m_export, CTRL+Key_E );
   m_file->insertItem( i18n("&Print"), this, SLOT(printGraph()), CTRL+Key_P );
   m_file->insertSeparator();
//   m_file->insertItem( "Open as &template", this, SLOT(loadTempl()) );
//   m_file->insertItem( "Save &default template", this, SLOT(saveTempl()) );
//   m_file->insertSeparator();
   m_file->insertItem( i18n("&Close"), this, SLOT(closeWindow()), CTRL+Key_W );
   m_file->insertSeparator();
   m_file->insertItem (i18n("New &Window"),this,SLOT(newWindow()));
   
   
   QPopupMenu *m_edit = new QPopupMenu;
   CHECK_PTR( m_edit );
   m_edit->insertItem( i18n("&Copy"), this, SLOT(editCopy()), CTRL+Key_C );   
   m_edit->insertItem( i18n("&Paste"), this, SLOT(editPaste()), CTRL+Key_V );
   m_edit->insertItem( i18n("C&ut"), this, SLOT(editCut()), CTRL+Key_X );
   m_edit->insertSeparator();
   m_edit->insertItem( i18n("&Rename"), this, SLOT(editRename()) );

   QPopupMenu *m_axes = new QPopupMenu;
   CHECK_PTR( m_axes );
   m_axes->insertItem( i18n("X bottom"), graphpanel, SLOT(propXBAxis()) );   
   m_axes->insertItem( i18n("Y left"), graphpanel, SLOT(propYLAxis()) );   
   m_axes->insertItem( i18n("X top"), graphpanel, SLOT(propXTAxis()) );   
   m_axes->insertItem( i18n("Y right"), graphpanel, SLOT(propYRAxis()) );   
   
   m_prop = new QPopupMenu;
   CHECK_PTR( m_prop );
   m_prop->insertItem( i18n("&Current object"), graphpanel, SLOT(propCurrent()) );
   m_prop->insertItem( i18n("&Graph"), graphpanel, SLOT(propGraph()) );   
   m_prop->insertItem( i18n("&Bottom axis"), graphpanel, SLOT(propXBAxis()) );   
   m_prop->insertItem( i18n("&Left axis"), graphpanel, SLOT(propYLAxis()) );   
   m_prop->insertItem( i18n("&Top axis"), graphpanel, SLOT(propXTAxis()) );   
   m_prop->insertItem( i18n("&Right axis"), graphpanel, SLOT(propYRAxis()) );   
   m_prop->insertSeparator();   
   m_prop->insertItem( i18n("Show Toolbar"), this, SLOT(toolbarSlot()),0, TOOLBAR_ID );   
   m_prop->insertItem( i18n("Tool Statusbar"), this, SLOT(statusbarSlot()),0, STATUSBAR_ID );   
   m_prop->setItemChecked(TOOLBAR_ID,TRUE);
   m_prop->setItemChecked(STATUSBAR_ID,TRUE);
   
   QPopupMenu *m_help = new QPopupMenu;
   CHECK_PTR( m_help );
//   m_help->insertItem( i18n("&Contents"), this, SLOT(helpContents()), Key_F1);
   m_help->insertItem( i18n("&SampLin Graph"), this, SLOT(helpGraph()), Key_F1 );
   m_help->insertSeparator();
   m_help->insertItem( i18n("&About"), this, SLOT(helpAbout()) );
   
   menubar = new KMenuBar(this, "MenuBar");
   menubar->insertItem( i18n("&File"), m_file );
   menubar->insertItem( i18n("&Edit"), m_edit );   
   menubar->insertItem( i18n("&Properties"), m_prop );   
   menubar->insertSeparator();
   menubar->insertItem( i18n("&Help"), m_help );   
   setMenu(menubar);
   
   statusbar = new KStatusBar(this);
   statusbar->insertItem("Object:                                                      ", ID_OBJECT);
   statusbar->insertItem("Position:                               ", ID_POSITION);
//   statusbar->insertItem("", ID_COMMON);
   statusbar->setInsertOrder(KStatusBar::LeftToRight);
   statusbar->setBorderWidth(2);
   

   
   setStatusBar(statusbar);


   connect(graphpanel, SIGNAL(pointShow(int,float,float)),this,SLOT(pointShowSlot(int, float, float)));
   connect(graphpanel, SIGNAL(objectChange(int, uint)),this,SLOT(objectSlot(int, uint)));
   connect(graphpanel, SIGNAL(filenameChanged()),this,SLOT(updateCaption()));
   setView(graphpanel);
   objectSlot(0,0);
   
/*   KNewPanner *panner;
   QWidget *w1,*w2;
   
  
   panner = new KNewPanner(this, "panner");

   w1 = new Graph(panner);   
   w2 = new KTreeList(panner);
   panner->activate(w1,w2);
   panner->setLabels("Graph", "Options");
   panner->showLabels(TRUE);
   setView(panner);*/
//   setId(id);
   updateCaption();
  
   KDNDDropZone *dropZone = new KDNDDropZone(this,DndURL);
   connect(dropZone,SIGNAL(dropAction(KDNDDropZone *)),
	   this,SLOT(dropAction(KDNDDropZone *)));
}


GraphWindow::~GraphWindow()
{
//   delete   toolbar;
//   delete   statusbar;   
//   delete   menubar;
  // delete   graphpanel;
}

void GraphWindow::dropAction(KDNDDropZone *dropZone) 
{
   char *s;
   
   QStrList &list = dropZone->getURLList();
   for (s = list.first(); s != 0L; s = list.next()) {
      // Load the first file in this window
      
      if (s == list.getFirst() && graphpanel->isSaved()) {
	// loadURL(s);
      } else {
	 GraphWindow *gw = new GraphWindow();
	 //gw->readConfig();
	 //gw->loadURL(s);
	 //gw->init();
      }
   }
}



void GraphWindow::resizeEvent( QResizeEvent *e )
{
   KTMainWindow/*MainWidget*/::resizeEvent(e);
}


void GraphWindow::paintEvent(QPaintEvent *)
{

}

void GraphWindow::closeWindow()
{
   close();
}


void GraphWindow::printGraph()
{
   graphpanel->print();
}

void GraphWindow::editCut()
{
   graphpanel->editCut();
}

void GraphWindow::editPaste()
{
   graphpanel->editPaste();
}

void GraphWindow::editRename()
{
   graphpanel->editRename();
}

void GraphWindow::editCopy()
{
   graphpanel->editCopy();
}


void GraphWindow::pointShowSlot(int button, float x, float y)
{
char str[64];
   
   if(1/*button==LeftButton*/){
      sprintf(str,"Position: [ %g, %g ]",x,y);
      statusbar->changeItem(str,ID_POSITION);
   }
   
}

void GraphWindow::loadTempl()
{
   graphpanel->loadTempl();
}

void GraphWindow::saveTempl()
{
   graphpanel->saveTempl();
}

void GraphWindow::loadGraph()
{

   graphpanel->load();
//   updateCaption();
}

void GraphWindow::saveGraph()
{
   graphpanel->save();
//   updateCaption();
}
void GraphWindow::saveAsGraph()
{
   graphpanel->saveAs();
//   updateCaption();
}

void GraphWindow::exportASCII()
{

   graphpanel->exportASCII();
      
}

void GraphWindow::exportPic()
{

   graphpanel->exportPic();
      
}


void GraphWindow::importASCII()
{

   graphpanel->importASCII();
      
}

void GraphWindow::updateCaption()
{
//   QString num;
//   if(graphpanel!=NULL)
//     num.setNum(getId());
     setCaption(QString("SampLinGraph ")/*+num+"."+name()+") "*//*+QString(graphpanel->label())*/+" ["+graphpanel->fileName()+"]");
   
}

bool GraphWindow::queryExit()
{
   
   return true;
   
}

//void GraphWindow::closeEvent( QCloseEvent *)
bool GraphWindow::queryClose(void)
 {
    int sel;
    static bool lock_flag=FALSE;

    while(lock_flag==TRUE);
    
    if(graphpanel->isSaved()==FALSE){
       lock_flag=TRUE;
       sel=QMessageBox::information( this, "Graph window",
				    "Session contains unsaved data\n"
				    "Do you want to save it before closing ?",
				    "&Save", "&Don't Save", "&Cancel",
				    0, 2 );
       lock_flag=FALSE;
       
       switch(sel) {
	case 0:   saveGraph();
	  break;
	case 1:
	  break;
	case 2:   return FALSE;
       }
    }
    emit closeSignal(win_id);
    //delete this;
    return TRUE;
}

void GraphWindow::objectSlot(int obj, uint key)
{
   QString s,tmp;
   
   switch(obj){
    case OBJ_GRAPH:
      s="Object: Graph";
      break;
    case OBJ_XBOTTOM:
      s="Object: Bottom axis";
      break;
    case OBJ_XTOP:
      s="Object: Top axis";
      break;
    case OBJ_YLEFT:
      s="Object: Left axis";
      break;
    case OBJ_YRIGHT:
      s="Object: Right axis";
      break;
    case OBJ_SERIES:
      tmp=graphpanel->curveName(key);
//      debug("key:%u,name:%s",key,tmp.data());
      if(strlen(tmp)==0)tmp=" ";
      s=QString("Object: Series [")+tmp+"]";
      break;
    case OBJ_NONE:
    default:
      s="Object:";
      break;
   }
   statusbar->changeItem(s,ID_OBJECT);
}

void GraphWindow::toolbarSlot()
{
//   toolbar->enable(KToolBar::Toggle);

   enableToolBar(KToolBar::Toggle);
   m_prop->setItemChecked(TOOLBAR_ID, toolbar->isVisible());
      
}

void GraphWindow::statusbarSlot()
{
//   statusbar->enable(KStatusBar::Toggle);

   enableStatusBar(KStatusBar::Toggle);
   m_prop->setItemChecked(STATUSBAR_ID, statusbar->isVisible());
      
}

void GraphWindow::helpAbout()
{
   
      SamplinAbout *about;
   
      about = new SamplinAbout(this, "About", FALSE);
      about->show();
   
      delete about;
}

void GraphWindow::helpContents()
{
      kapp->invokeHTMLHelp("","");
}

void GraphWindow::helpGraph()
{
      kapp->invokeHTMLHelp("","Graph");
}

void GraphWindow::newWindow()
{
 
   GraphWindow *gw = new GraphWindow(NULL);
   gw->show();
}

/*
void KWrite::loadURL(const char *url, int flags) {
     KURL u(url);
   
     if (u.isMalformed()) {
	    QString s;
	    if (url) {
	             s = "file:";
	             if (*url != '/') {
			s += QDir::currentDirPath();
			        s += '/';
		     }
	             s += url;
	             u.parse(s);
	    }
	    if (u.isMalformed()) {
	             s.sprintf("%s\n%s",i18n("Malformed URL"),url);
	       QMessageBox::warning(this,
				            i18n("Sorry"),
				            s,
				            i18n("OK"),
				            "",
				            "",
				            0,0);
	             return;
	    }
     }
    if (u.isLocalFile()) {
           // usual local file
           emit statusMsg(i18n("Loading..."));
       
           QString name(u.path());
       KURL::decodeURL(name);
           if (loadFile(name,flags)) {
	            name = u.url();
	            if (flags & lfInsert) {
		               name.prepend(": ");
		               name.prepend(i18n("Inserted"));
		    } else {
		               if (!(flags & lfNoAutoHl)) kWriteDoc->setFileName(name);
		                 else kWriteDoc->updateLines();
		               name.prepend(": ");
		               name.prepend(i18n("Read"));
		    }
	            emit statusMsg(name);
	   }
    } else {
    // url
           if (kfm != 0L) {
	      QMessageBox::information(this,
				               i18n("Sorry"),
				               i18n("KWrite is already waiting\nfor an internet job to finish\n"\
             "Please wait until it has finished\nAlternatively stop the running one."),
				               i18n("OK"),
				               "",
				               "",
				               0,0);
	            return;
	   }
           emit statusMsg(i18n("Waiting for KFM..."));
       
           kfm = new KFM;
           if (!kfm->isOK()) {
	      QMessageBox::warning(this,
				           i18n("Sorry"),
				           i18n("Could not start or find KFM"),
				           i18n("OK"),
				           "",
				           "",
				           0,0);
	            delete kfm;
	            kfm = 0L;
	            return;
	   }
           kfmURL = u.url();
           kfmFile.sprintf(_PATH_TMP"/kwrite%i",time(0L));
       kfmAction = KWrite::GET;
           kfmFlags = flags;
       
           connect(kfm,SIGNAL(finished()),this,SLOT(kfmFinished()));
           connect(kfm,SIGNAL(error(int, const char *)),this,SLOT(kfmError(int, const char *)));
           kfm->copy(url,kfmFile);
    }
}
*/
