/**************************************************************************
 * $Id: pcl818.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This is the Linux driver for Advantech PCL-818 card
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef  __PCL818_H
#define  __PCL818_H


#define  PCL818_SET_ADC_RANGE  (0)
 
//#define  PCL818_IO_TWOS_COMP  (1)

#define  PCL818_IO_UNIPOLAR  (2)
#define  PCL818_IO_BIPOLAR  (3)
#define  PCL818_IO_LOW_RANGE  (4)
#define  PCL818_IO_HIGH_RANGE  (5)

#define  PCL818_SETBIT_DO  (6)
#define  PCL818_IO_CT_MODE  (7)
#define  PCL818_IO_INFO  (8)
/*                                                                           */
#define  PCL818_ATO  (0x80)
#define  PCL818_FRM  (0x40)
#define  PCL818_BU   (0x20)
#define  PCL818_RGE  (0x10)

#define  PCL818_IRQE (0x80)
#define PCL818_CT_MODE_MASK 0x0e

#define  PCL818_CT_MODE_0  (0x00)
#define  PCL818_CT_MODE_1  (0x02)
#define  PCL818_CT_MODE_2  (0x04)
#define  PCL818_CT_MODE_3  (0x06)
#define  PCL818_CT_MODE_4  (0x08)
#define  PCL818_CT_MODE_5  (0x0a)

#define  PCL818_CT_PULSE_ON_TERMINAL_COUNT    PCL818_CT_MODE_0
#define  PCL818_CT_RETRIGGERABLE_ONE_SHOT     PCL818_CT_MODE_1
#define  PCL818_CT_RATE_GENERATOR             PCL818_CT_MODE_2
#define  PCL818_CT_SQUARE_WAVE_GENERATOR      PCL818_CT_MODE_3
#define  PCL818_CT_SOFTWARE_TRIGGERED_STROBE  PCL818_CT_MODE_4
#define  PCL818_CT_HARDWARE_TRIGGERED_STROBE  PCL818_CT_MODE_5

/*  These constants correspond to the limits of the ADCs.                    */
#define  PCL818_ADC_UNI_LO_MAX  (+0.255)
#define  PCL818_ADC_UNI_LO_MIN  (+0.000)

#define  PCL818_ADC_UNI_HI_MAX  (+9.961)
#define  PCL818_ADC_UNI_HI_MIN  (+0.000)

#define  PCL818_ADC_BI_LO_MAX  (+0.127)
#define  PCL818_ADC_BI_LO_MIN  (-0.128)

#define  PCL818_ADC_BI_HI_MAX  (+4.961)
#define  PCL818_ADC_BI_HI_MIN  (-5.000)


/*  These constants correspond to the limits of the DACs.                    */
#define  PCL818_DAC_MAX  (+9.922)
#define  PCL818_DAC_MIN  (-10.000)




/*  The ioctls below this line are for debugging purposes ONLY!              */
/*  Use at your own risk!                                                    */
#define  PCL818_DEBUG_IO_EN_AUTOCON   (9)   /*  Sets an ADC to autoconvert.   */
#define  PCL818_DEBUG_IO_DIS_AUTOCON  (10)  /*  Disable autoconv for an ADC.  */
#define  PCL818_DEBUG_IO_RIR          (11)  /*  Force a RIR.                  */
#define  PCL818_DEBUG_IO_ADC_START    (12)  /*  Force ADC conversion start.   */
#define  PCL818_DEBUG_IO_ADC_READ     (13)  /*  Force a read from the ADC.    */
#define  PCL818_DEBUG_IO_ADC_SELECT   (14)  /*  Explicitly select an ADC.     */

#define  PCL818_SET_DO  (20)
#define  PCL818_SET_DAC (21)


#endif  /*  not __PCL818_H  */


