/***************************************************************************
                          bhebinp.h  -  description
                             -------------------
    begin                : Sun Jan 2 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>

#include <qpushbt.h>
#include <qbttngrp.h>
#include <qcombo.h>

#include "bitana.h"
#include "bhebinp.h"
//#include "resource.h"

BHebInp::BHebInp(QWidget *parent, const char *name ) : QWidget(parent,name) {
}
BHebInp::~BHebInp(){
}

/** Initialisierung */

void BHebInp::init(){

// Hebfont setzten

  	extern BitanaApp *bitana;
		QFont hebfont(bitana->getHebFont1());

//	QFont hebfont( "" );
//	hebfont.setStyleHint( (QFont::StyleHint)2 );
//	hebfont.setCharSet( (QFont::CharSet)8 );

// Eingabestack initalisieren

	inpstack = new QStrList();

// Button Group for common slot define

	QButtonGroup* bgroup;
	bgroup = new QButtonGroup( this, "bgroup" );
	bgroup->setGeometry( 0, 5, 2 * BBO + 4 * BDI + BSI, 6 * BDI + BSI + 3 * BBO );
	bgroup->setMinimumSize( 2 * BBO + 4 * BDI + BSI, 6 * BDI + BSI + 3 * BBO );
	bgroup->setMaximumSize( 2 * BBO + 4 * BDI + BSI, 6 * BDI + BSI + 3 * BBO );
//	bgroup->setFocusPolicy( QWidget::NoFocus );
//	bgroup->setBackgroundMode( QWidget::PaletteBackground );
//	bgroup->setFontPropagation( QWidget::NoChildren );
//	bgroup->setPalettePropagation( QWidget::NoChildren );
	bgroup->setFrameStyle( 49 );
	bgroup->setTitle( i18n("Hebinput") );
	bgroup->setAlignment( 1 );

 // Inputline - Widget

  in = new QComboBox( true, this, "in" );
	in->setGeometry( BBO, 2 * BBO, 4 * BDI + BSI, BSI );
	in->setMinimumSize( 4 * BDI + BSI, BSI );
	in->setMaximumSize( 4 * BDI + BSI, BSI );
	in->setFont( hebfont );
	in->setEnabled(true);
  in->clearEdit();
	wmod = true;
	
  QPushButton *but;

// Aufbau des Eingabefeldes

  char  cb[2] = " ";             // Tastenbezeichnung
  int i,k;
  int xs = BBO, ys= 3 * BBO + BSI;	// Pos. des 1. Buttonx, y - offset fr Positionen

  k=0;
  for (i=0; i<27; i++) {
     cb[0] = (char)(HEB_BEG+i);

    but  = new QPushButton(this, "heb");
		but->setGeometry( xs, ys, BSI, BSI );
		but->setMinimumSize( BSI, BSI );
		but->setMaximumSize( BSI, BSI );
		but->setFont( hebfont );
		but->setText( cb );
		but->setAutoRepeat( FALSE );
		but->setAutoResize( FALSE );
		bgroup->insert(but);

    if (k++ < 4) xs += BDI;
    else {
        xs = BBO; k = 0;
        ys += BDI;
     }
  }

	// drei witere Buttons, der erste kannauch anders
	// verwendet werden s. Auswertung Tastendruck

	// '-' Bindestrich

  but  = new QPushButton(this, "-");
	but->setGeometry( xs, ys, BSI, BSI );
	but->setMinimumSize( BSI, BSI );
	but->setMaximumSize( BSI, BSI );
	but->setFont( hebfont );
	but->setText( "-" );
	but->setAutoRepeat( FALSE );
	but->setAutoResize( FALSE );
	bgroup->insert(but);
	xs += BDI;

	// 'M' memory - Wort Speichern

  but = new QPushButton(this, "M");
	but->setGeometry( xs, ys, BSI, BSI );
	but->setMinimumSize( BSI, BSI );
	but->setMaximumSize( BSI, BSI );
	but->setFont( hebfont );
	but->setText( "M" );
	but->setAutoRepeat( FALSE );
	but->setAutoResize( FALSE );
	bgroup->insert(but);
  xs += BDI;

	// 'C' clear - Wort lschen

  but = new QPushButton(this, "C");
	but->setGeometry( xs, ys, BSI, BSI );
	but->setMinimumSize( BSI, BSI );
	but->setMaximumSize( BSI, BSI );
	but->setFont( hebfont );
	but->setText( "C" );
	but->setAutoRepeat( FALSE );
	but->setAutoResize( FALSE );
	bgroup->insert(but);

	resize( 2 * BBO + 4 * BDI + BSI + 10, 6 * BDI + BSI + 3 * BBO + 10);
	setMinimumSize( 2 * BBO + 4 * BDI + BSI +10, 6 * BDI + BSI + 3 * BBO + 10 );
	setMaximumSize( 2 * BBO + 4 * BDI + BSI +10, 6 * BDI + BSI + 3 * BBO + 10 );

	connect(bgroup, SIGNAL(clicked(int)), this, SLOT(slotPressx(int)));
	connect(in, SIGNAL(activated(int)), this, SLOT(slotNewWord(int)));
}


/** Auswertung Tastendruck */
void BHebInp::slotPressx(int taste){
		
	switch (taste)	{

		case 27:
			c = '-';
			// dieser button kann auch anders verwender werden
			// Eingabe '-' dann ber Tastatur !
			word = word.insert(0, &c);	// von rechts nach links
			wmod = true;
			in->setEditText(word.rightJustify(13, ' '));
			break;

		case 28:
			// c = 'M' memory
			in->insertItem(word.rightJustify(13, ' '), 0);
			in->clearEdit();
			word = "";
			wmod = true;
			break;

		case 29:
			// c = 'C' clear
			if (wmod) {
				in->clearEdit();
				word = "";
			}
			else {
				in->removeItem(in->currentItem());
				in->setCurrentItem(0);
				in->clearEdit();
				word = "";
				wmod = true;
			}
			break;

		default:
			c = HEB_BEG + taste;
			word = word.insert(0, &c);	// von rechts nach links
			wmod = true;
			in->setEditText(word.rightJustify(13, ' '));
			break;
	}

}

/** Auswahl eines Wortes aus Liste */
void BHebInp::slotNewWord(int item){

  wmod = false;
	word = in->text(item);
	word = word.stripWhiteSpace();

//	in->setEditText(word.rightJustify(13, ' '));

}


/** Reading the Input */
QString BHebInp::readInput()
{
	return ( word.stripWhiteSpace() );
}

QStrList* BHebInp::liesInputStack() {
	
	QString tmp;
  inpstack->clear();
	for (int i=0; i<in->count(); i++) {
		tmp = in->text(i);
		tmp = tmp.stripWhiteSpace();  // Rechstbund lsen
		inpstack->append(tmp);
	}
  return (inpstack);
}

void BHebInp::setInputStack(QStrList *inplist) {

	QString tmp;
	if (inplist->isEmpty()) return;
	for (unsigned  i=0; i<inplist->count(); i++) {
		tmp = inplist->take(i);
		tmp = tmp.rightJustify(13, ' ');  // Rechtsbndig auf 13 Stellen	
	inplist->insert(i, tmp);
	}
	in->insertStrList(inplist);
	slotNewWord(0);
}







