/***************************************************************************
                          bibdoc.h  -  description
                             -------------------
    begin                : Mit Dez 29 13:12:29 MET 1999
    copyright            : (C) 1999 byHans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BIBDOC_H
#define BIBDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <ksimpleconfig.h>
#include <qwidget.h>

#include <bitana.h>

// forward declaration of the Bitana classes
class BibView;

/**	BibDoc provides a document object for a document-view model.
  *
	* The BibDoc class provides a document object that can be used in conjunction with the classes BitanaApp and BibView
	* to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
	* is created by the BitanaApp instance and contains the document structure with the according methods for manipulation of the document
	* data by BibView objects. Also, BibDoc contains the methods for serialization of the document data from and to files.
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
	* @version KDevelop version 0.4 code generation
	*/
class BibDoc : public QObject
//class BibDoc : public KSimpleConfig
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  BibDoc(QWidget* parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~BibDoc();
  /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified(bool modified=true){ b_modified=modified; }
	/** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified(){ return b_modified;}
	/** "save modified" - asks the user for saving if the document is modified */
  bool saveModified();	
  /** delet the contens of parameters */
  void deleteContents();
	/** initializes the document generally */
	bool newDocument();
	/** closes the acutal document */
	void closeDocument();
	/** loads the document by filename and format and emits the updateViews() signal */
  bool openDocument(const char* filename, const char* format=0);
  /** saves the document under filename and format.*/	
  bool saveDocument(const char* filename, const char* format=0);
	/** sets the path to the file connected with the document */
	void pathName(const char* path_name);
	/** returns the pathname of the current document file*/
	const QString& getPathName() const;
	/** sets the filename of the document */
	void title(const char* title);
	/** returns the title of the document */
	const QString& getTitle() const;
	BibView* getView() const;
	
 public slots:
 	/** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
 	  * As this view normally repaints itself, it is excluded from the paintEvent. */
// 	void slotUpdateAllViews(BibView* pSender);
 	
 public:	
 	/** the list of the views currently connected to the document */
	static QList<BibView>* viewList;	


 private:
 	/** the modified flag of the current document */
 	bool b_modified;
	QString m_title;
	QString m_path;
  KSimpleConfig *config;
  BibView *view;

};

#endif // BIBDOC_H


























