/***************************************************************************
                          bibview.cpp  -  description
                             -------------------
    begin                : Mit Dez 29 13:12:29 MET 1999
    copyright            : (C) 1999 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "bibview.h"

#include "iostream.h"

#include <qfile.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qtextstream.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qsize.h>
#include <qstrlist.h>

// application specific includes

#include "bdoclst.h"
#include "bitana.h"

#define STRSEP "\t"
#define SEP    '\t'

BibView::BibView(QWidget *parent, const char* name) : QWidget(parent, name)
{

//	setBackgroundMode( PaletteBase );

 	extern BitanaApp *bitana;
	parent->setUpdatesEnabled ( FALSE);

// Erzeugen aller Widget-Objekte

	inp = new BHebInp(this);
	inp->init();

	tab = new BTabCtl(this);

	anz = new BAnzPar(tab);
	inv = new BIntPar(tab);
	nbr = new BNbrPar(tab);
	lex = new BLexPar(tab);

	tab->addTab(anz, i18n("Text/Gematria"));
	tab->addTab(inv, i18n("ELS"));
	tab->addTab(nbr, i18n("Neighbour"));
	tab->addTab(lex, i18n("Dictionary"));

	// Tabgrsse an heb-inp-Groesse anpassen

	QSize s = inp->maximumSize();
	tab->setMaximumSize(32767, s.height() );

	// Doc-(Ergebnissdateien)Widgets als Splitter zusammensetzen

	sh = new QSplitter(QSplitter::Horizontal, this);

  dlst = new BDocLst(sh);
	dlst->resize(20, 0);
	sv1 = new QSplitter(QSplitter::Vertical, sh);

	dkop = new QMultiLineEdit(sv1);
  dkop->resize(0, 10);
	dkop->setFont(bitana->getHebFont2());

// berlagerung der Ausgabewidgets mit Stacktechnik

	docw = new QWidgetStack(sv1);

  dtxt = new QMultiLineEdit(docw);	
	dtxt->setFont(bitana->getHebFont2());
	docw->addWidget(dtxt, 1);

	dmat = new BTextMatrix(docw);
  docw->addWidget(dmat, 3);

  dpic = new BGrafik(docw);
	docw->addWidget(dpic, 4);


// 2 Main layouts

	vl1 = new QVBoxLayout(this);
	vl2 = new QVBoxLayout(this);

// Unterlayouts definieren

	hl1 = new QHBoxLayout();
//	vsl1 = new QVBoxLayout(sv1);	

	vl1->addLayout(hl1, 0);
	vl1->addSpacing(1);
	vl1->addWidget(sh, 10);

  vl2->addWidget(sh);

	hl1->addWidget(inp, 0, AlignTop);
	hl1->addSpacing(1);
	hl1->addWidget(tab, 0, AlignTop);

 	vl1->activate();

	connect(dlst, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotResDoc(QListViewItem *)));

}

BibView::~BibView(){

}

/** toggles the main view between
 edit and only output view */
void BibView::toggleView(){

	if (inp->isVisible ()) {
  	inp->hide();
		tab->hide();
   	vl2->activate();

	} else {
		inp->show();
		tab->show();
 		vl1->activate();
 		}
}


BibDoc* BibView::getDocument() const
{
	BitanaApp* theApp=(BitanaApp*)parentWidget();
	return theApp->getDocument();
}

void BibView::print(QPrinter* m_pPrinter)
{
	QPainter printpainter;
	printpainter.begin(m_pPrinter);
	
	// TODO: add your printing code here
	
	printpainter.end();

}

/** Parameter auslesen */

/** Textausschnitt - Breite */
int BibView::lesAusBr(){
	return (anz->liesAusBr());
}

QString BibView::lesAbbWort() {
	return(anz->liesAbbWort());
}

int BibView::lesAbbBeg() {
	return(anz->liesAbbBeg());
}

int BibView::lesAbbIntWeite() {
	return(anz->liesAbbIntWeite());
}

QString* BibView::lesNbrWorte() {
	return (nbr->liesNbrWorte());
}

void BibView::setNbrWort(int i, QString wort) {
	nbr->setNbrWort(i, wort);
}

QStrList* BibView::lesInputStack() {
	return (inp->liesInputStack());
}

void BibView::setInputStack(QStrList *inpl) {
	inp->setInputStack(inpl);
}

void BibView::setAusBr(int breite) {
	return(anz->setAusBr(breite));
}

void BibView::setAbbWort(QString wo) {
	return (anz->setAbbWort(wo));
}

void BibView::setAbbBeg(int beg) {
	return (anz->setAbbBeg(beg));
}

void BibView::setAbbIntWeite(int wei) {
	return (anz->setAbbIntWeite(wei));
}

QString BibView::lesIntWort(){
	return(inv->liesIntWort());
}

bool BibView::lesAnalyse(){
	return(inv->liesAnalyse());
}

int BibView::lesRichtung(){
	return(inv->liesRichtung());
}

bool BibView::lesSortierung(){
	return(inv->liesSortierung());
}

int BibView::lesIntwVon(){
	return(inv->liesIntwVon());
}

int BibView::lesIntwBis(){
	return(inv->liesIntwBis());
}


void BibView::setIntWort(QString wo){
	inv->setIntWort(wo);
}

void BibView::setAnalyse(bool a){
	inv->setAnalyse(a);
}

void BibView::setRichtung(int r) {
	inv->setRichtung(r);
}

void BibView::setSortierung(bool s){
	inv->setSortierung(s);
}

void BibView::setIntwVon(int wv){
	inv->setIntwVon(wv);
}
	
void BibView::setIntwBis(int wb){
	inv->setIntwBis(wb);
}

bool BibView::lesAnzAus() {
	return( anz->liesAus());
}

bool BibView::lesAnzDar(){
	return( anz->liesDar());
}

bool BibView::lesAnzAbb(){
	return(anz->liesAbb());
}

bool BibView::lesAnzWordAna(){
	return(anz->liesWordAna());
}

void BibView::setAnzAus(bool b){
	anz->setAus(b);
}

void BibView::setAnzDar(bool b){
	anz->setDar(b);
}

void BibView::setAnzAbb(bool b){
	anz->setAbb(b);
}

void BibView::setAnzWordAna(bool b){
	anz->setWordAna(b);
}

/** Marked the fileItem in DocList and show the Document */
void BibView::markFileItem(QString file) {

  QListViewItem *ifile, *igroup, *item;
  int i;
  if (dlst->resultList() == 0) return;

	if ((ifile = dlst->itemFile(file)) == NULL) return;
	if (ifile->isSelected()) (ifile->listView())->setSelected(ifile, false);
	igroup =  ifile->parent();
	
	item = dlst->firstChild();
  for (i=0; i < dlst->childCount(); i++){
		if (item == igroup) item->setOpen(true);
			else item->setOpen(false);
		item = item->nextSibling();
	};
   (ifile->listView())->setSelected(ifile, true);
}


/** Ausgewaehltes Ergebnisdokument anzeigen */
void BibView::slotResDoc(QListViewItem *item){

	QString fname = item->text(1);
	if (fname.find(".lst") < 1) return;
	showDoc( fname);

}

/** Ausgabe eines Ergebnisdokuments
in die entsprechenden Fenster */
bool BibView::showDoc(QString file){

	extern BitanaApp *bitana;
 	QFile f1;
 	int dtyp;
	int p;
 	QString zeile;
 	QString s,t;

	QDir d=QDir::root();
 	if (d.cd(bitana->getTmpDir())) f1.setName(d.filePath(file));
 	else
 	{
  QMessageBox::warning(0,i18n("Cannot find the working directory"),
                          bitana->getTmpDir());
  return FALSE;
 }
 if (!f1.open(IO_ReadOnly))
                QMessageBox::warning(0,i18n("Cannot find the file"),
                                       f1.name());
 	QTextStream dat(&f1);

 	zeile=dat.readLine();
 	char z=zeile.at(0);

// Typ der Tabelle feststellen

 	if(z!='#') return FALSE;			// keine Steuerzeile
 	zeile.remove(0,2);

 	if(!strcmp(zeile,"Text")) {  // Text Document
  	dtyp = 1;
		dtxt->clear();
    zeile=dat.readLine();
  	z=zeile.at(0);
  	if(z!='#') return FALSE;      // 2.Steuerzeile (Kopfzeilen) existiert nicht -> Fehler
 	}

 	if(!strcmp(zeile,"Tabelle")) { //Tabellen-dokument
		
    docw->removeWidget(dtab);
		delete dtab;	
		dtab = new KTabListBox(docw);
		dtab->setTableFont(bitana->getHebFont2());
		docw->addWidget(dtab, 2);
    dtab->setAutoUpdate(false);
		dtyp = 2;
		dtab->clear();
  	zeile=dat.readLine();
  	z=zeile.at(0);
  	if(z!='#') return FALSE;      // 2.Steuerzeile existiert nicht -> Fehler
  	zeile.remove(0,3);
  	p=zeile.find(STRSEP);
  	s=zeile.left(p);
  	uint l=s.toInt();             // Anzahl Spalten
  	dtab->setNumCols(s.toInt());
  	zeile.remove(0,p+1);

  	for(uint i=0;i<l;i++)         // Spalten setzen
  	{
   		p=zeile.find("\t");
   		t=zeile.left(p);
   		zeile.remove(0,p+1);
  		p=zeile.find("\t");
   		s=zeile.left(p);
   		zeile.remove(0,p+1);
   		dtab->setColumn(i,t,s.toInt());
  	}
  	dtab->setSeparator(SEP);
 	}

	if(!strcmp(zeile,"Matrix")) { // Matrix-dokument
  	dtyp = 3;
		dmat->clear();
	  zeile = dat.readLine();
	  z=zeile.at(0);
  	if(z!='#') return FALSE;      // 2.Steuerzeile existiert nicht -> Fehler
    zeile.remove(0,2);
		p=zeile.find(STRSEP);
   	s=zeile.left(p); 							// anzahl Spalten
    dmat->setSpalten(s.toInt());
  }
	
	if(!strcmp(zeile,"Grafik")) { 	// Picture-dokument
    docw->removeWidget(dpic);
		delete dpic;	
		dpic = new BGrafik(docw);
//		dpic->setTableFont(bitana->getHebFont2());
		docw->addWidget(dpic, 4);


  	dtyp = 4;
		zeile = dat.readLine();
	  z=zeile.at(0);
	}

	// Titelzeilen fr fr AusgabeFenster
  dkop->clear();
 	do {
		zeile=dat.readLine();
  	z=zeile.at(0);
  	if(z=='#'){
			zeile.remove(0,2);
   		dkop->append(zeile);
  	}
 	} while(z=='#');


	// Daten ausgeben
	 do {
		switch(dtyp) {
			case 1:
				dtxt->append(zeile);
				break;
			case 2:
				dtab->appendItem(zeile);
				break;
			case 3:
				dmat->addMatrixLine(zeile);
				break;
			case 4:
				dpic->addGraLine(zeile);
				break;
		}
		zeile=dat.readLine();
	} while (!(zeile.isEmpty() && dat.eof()));


// Nachbearbeitung nach Datenausgabe, Anzeige aus Widget Stack

		switch(dtyp) {
			case 1:
				docw->raiseWidget(dtxt);
				break;
			case 2:
				dtab->setAutoUpdate(true);
				docw->raiseWidget(dtab);
				break;
			case 3:
        dmat->setZeilen(0);
				docw->raiseWidget(dmat);
				break;
			case 4:
				docw->raiseWidget(dpic);	
				dpic->setBildOk();						// fertig ausgegeben
				dpic->update();
				break;
		}

	sv1->refresh();
 	return TRUE;
}

int BibView::tabSelected() {
	return tab->getCurrentTab();
}

void BibView::selectTab(int id) {
	tab->setCurrentTab(id);
}


























































